/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class HasCraftRemainderItem
extends Item {
    protected Supplier<Item> craftRemainderSupplier;

    public HasCraftRemainderItem(Supplier<Item> craftRemainderSupplier, Item.Properties properties) {
        super(properties);
        this.craftRemainderSupplier = craftRemainderSupplier;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder result = super.use(level, player, hand);
        if (((ItemStack)result.getObject()).isEmpty()) {
            return new InteractionResultHolder(result.getResult(), (Object)this.getCraftingRemainingItem((ItemStack)result.getObject()));
        }
        return result;
    }

    public ItemStack finishUsingItem(ItemStack item, Level level, LivingEntity entity) {
        Player player;
        ItemStack container = item.getCraftingRemainingItem();
        ItemStack result = super.finishUsingItem(item, level, entity);
        if (result.isEmpty()) {
            return container;
        }
        if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
            player.getInventory().add(container);
        }
        return result;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)this.craftRemainderSupplier.get());
    }
}

