/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class HellenicArmorItem
extends ArmorItem {
    private static final String TEXTURE_1 = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/models/armor/hellenic_layer_1.png").toString();
    private static final String TEXTURE_2 = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/models/armor/hellenic_layer_2.png").toString();
    private static final String TEXTURE_3 = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/models/armor/hellenic_layer_3.png").toString();
    private static final TagKey<Item> ACHILLES_ITEM = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"achilles_heel"));

    public HellenicArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type slot, Item.Properties properties) {
        super(armorMaterial, slot, properties);
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 18;
    }

    public static int getAchillesCount(LivingEntity entity) {
        int armorCount = 0;
        for (ItemStack itemStack : entity.getArmorSlots()) {
            if (!itemStack.is(ACHILLES_ITEM)) continue;
            ++armorCount;
        }
        return armorCount;
    }

    public static boolean isImmune(LivingEntity entity, Projectile projectile, double dotProduct, int armorCount) {
        return dotProduct < -0.7 && armorCount > 0 && entity.getRandom().nextInt(4) + 1 < armorCount;
    }

    public static boolean damageArmor(LivingEntity entity, int amount) {
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD}) {
            ItemStack itemStack = entity.getItemBySlot(slot);
            if (!itemStack.is(ACHILLES_ITEM)) continue;
            itemStack.hurtAndBreak(1, entity, slot);
            return true;
        }
        return false;
    }

    public static boolean isCritical(LivingEntity entity, AbstractArrow projectile, double dotProduct, int armorCount) {
        return dotProduct > 0.64 && armorCount > 0 && projectile.getY() < entity.getY() + (double)entity.getBbHeight() * 0.5;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"item.greekfantasy.hellenic_armor.tooltip.resist").withStyle(ChatFormatting.GOLD));
        list.add((Component)Component.translatable((String)"item.greekfantasy.hellenic_armor.tooltip.weak").withStyle(ChatFormatting.RED));
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        switch (slot) {
            case HEAD: {
                return ResourceLocation.parse((String)TEXTURE_3);
            }
            case LEGS: {
                return ResourceLocation.parse((String)TEXTURE_2);
            }
        }
        return ResourceLocation.parse((String)TEXTURE_1);
    }
}

