/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GreekFantasy;
import greekfantasy.item.HasCraftRemainderItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class HornOfPlentyItem
extends HasCraftRemainderItem {
    private static final ResourceKey<LootTable> LOOT_TABLE_LOCATION = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"gameplay/horn_of_plenty"));

    public HornOfPlentyItem(Supplier<Item> craftRemainderSupplier, Item.Properties properties) {
        super(craftRemainderSupplier, properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            this.sampleLoot(player, itemStack).forEach(item -> {
                ItemEntity itemEntity = player.spawnAtLocation(item);
                if (itemEntity != null) {
                    itemEntity.setNoPickUpDelay();
                }
            });
        }
        ItemStack container = this.getCraftingRemainingItem(itemStack);
        int damage = (Integer)GreekFantasy.CONFIG.HORN_OF_PLENTY_DURABILITY_ON_USE.get();
        if (!player.isCreative() && damage > 0) {
            itemStack.hurtAndBreak(damage, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
        player.getCooldowns().addCooldown((Item)this, 5);
        return InteractionResultHolder.sidedSuccess((Object)(itemStack.isEmpty() ? container : itemStack), (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")).withStyle(ChatFormatting.GRAY));
    }

    protected List<ItemStack> sampleLoot(Player player, ItemStack itemStack) {
        LootTable loottable = player.level().getServer().reloadableRegistries().getLootTable(LOOT_TABLE_LOCATION);
        return loottable.getRandomItems(new LootParams.Builder((ServerLevel)player.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.TOOL, (Object)itemStack).create(LootContextParamSets.GIFT));
    }
}

