/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.client.screen.ScreenLoader;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class InstrumentItem
extends Item {
    protected final Supplier<SoundEvent> sound;

    public InstrumentItem(Item.Properties properties, Supplier<SoundEvent> sound) {
        super(properties);
        this.sound = sound;
    }

    public float getVolume() {
        return 1.25f;
    }

    public SoundEvent getSound() {
        return this.sound.get();
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        if (worldIn.isClientSide()) {
            ScreenLoader.openInstrumentScreen(playerIn, playerIn.getInventory().selected, itemstack);
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.tooltip.right_click_instrument").withStyle(ChatFormatting.AQUA));
    }
}

