/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;

public class IvorySwordItem
extends SwordItem {
    public static final ResourceLocation ATTACK_DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"ivory_sword_attack_damage");
    public static final ResourceLocation ATTACK_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"ivory_sword_attack_speed");
    public static final ResourceLocation ATTACK_KNOCKBACK_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"ivory_sword_attack_knockback");
    public static final double ATTACK_KNOCKBACK_AMOUNT = 1.25;
    protected final Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMap;

    public IvorySwordItem(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(tier, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ATTACK_DAMAGE_ID, (double)((float)attackDamageIn + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE));
        builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ATTACK_SPEED_ID, (double)attackSpeedIn, AttributeModifier.Operation.ADD_VALUE));
        builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)new AttributeModifier(ATTACK_KNOCKBACK_ID, 1.25, AttributeModifier.Operation.ADD_VALUE));
        this.attributeModifierMap = builder.build();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        super.hurtEnemy(stack, target, attacker);
        if (attacker instanceof Player && !(player = (Player)attacker).getCooldowns().isOnCooldown((Item)this)) {
            float knockback = 1.25f;
            target.knockback((double)(knockback * 0.75f), (double)Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)))));
        }
        return true;
    }
}

