/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GreekFantasy;
import greekfantasy.util.WeightedMobEffectInstance;
import greekfantasy.util.WeightedUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class OliveSalveItem
extends Item {
    public static final String KEY_USE_EFFECT = "UseEffect";
    public static final String KEY_BONUS_EFFECTS = "BonusEffects";
    public static final String KEY_ROLLS = "Rolls";
    public static final String KEY_ID = "Id";

    public OliveSalveItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.CROSSBOW;
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity entity) {
        if (!level.isClientSide()) {
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            effects.add(this.getPrimaryEffectInstance(itemStack));
            int rolls = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt(KEY_ROLLS);
            effects.addAll(this.getBonusEffectInstances(itemStack, rolls, entity.getRandom()));
            for (MobEffectInstance effect : effects) {
                if (effect == null) continue;
                entity.addEffect(effect);
            }
        }
        return super.finishUsingItem(itemStack, level, entity);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        MobEffect primaryEffect = this.getPrimaryEffect(itemStack);
        if (primaryEffect != null) {
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip"), (Object[])new Object[]{Component.translatable((String)primaryEffect.getDescriptionId())}).withStyle(ChatFormatting.BLUE));
        } else {
            list.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.BLUE));
        }
    }

    @Nullable
    private MobEffect getPrimaryEffect(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (customData.isEmpty()) {
            return null;
        }
        CompoundTag useEffectTag = customData.copyTag().getCompound(KEY_USE_EFFECT);
        return (MobEffect)BuiltInRegistries.MOB_EFFECT.byId((int)useEffectTag.getByte(KEY_ID));
    }

    @Nullable
    private MobEffectInstance getPrimaryEffectInstance(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (customData.isEmpty()) {
            return null;
        }
        return WeightedMobEffectInstance.fromTag(customData.copyTag().getCompound(KEY_USE_EFFECT)).createMobEffectInstance();
    }

    private List<MobEffectInstance> getBonusEffectInstances(ItemStack itemStack, int rolls, RandomSource random) {
        int i;
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (customData.isEmpty() || !tag.contains(KEY_BONUS_EFFECTS)) {
            return List.of();
        }
        ListTag effectList = tag.getList(KEY_BONUS_EFFECTS, 10);
        if (effectList.isEmpty()) {
            return List.of();
        }
        ArrayList<WeightedMobEffectInstance> weighted = new ArrayList<WeightedMobEffectInstance>();
        ArrayList<MobEffectInstance> mobEffects = new ArrayList<MobEffectInstance>();
        int n = effectList.size();
        for (i = 0; i < n; ++i) {
            weighted.add(WeightedMobEffectInstance.fromTag(effectList.getCompound(i)));
        }
        for (i = 0; i < rolls; ++i) {
            GreekFantasy.LOGGER.debug("Adding effect...");
            WeightedMobEffectInstance weightedEntry = (WeightedMobEffectInstance)((Object)WeightedUtil.sample(weighted, random));
            if (weightedEntry == null) continue;
            mobEffects.add(weightedEntry.createMobEffectInstance());
        }
        return mobEffects;
    }
}

