/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GFRegistry;
import greekfantasy.entity.Palladium;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PalladiumItem
extends Item {
    public PalladiumItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPlaceContext blockitemusecontext = new BlockPlaceContext(context);
        BlockPos blockpos = blockitemusecontext.getClickedPos();
        ItemStack itemstack = context.getItemInHand();
        Vec3 vector3d = Vec3.atBottomCenterOf((Vec3i)blockpos);
        AABB aabb = ((EntityType)GFRegistry.EntityReg.PALLADIUM.get()).getDimensions().makeBoundingBox(vector3d.x(), vector3d.y(), vector3d.z());
        if (world.noCollision(aabb) && world.getEntities(null, aabb).isEmpty()) {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                Palladium palladium = Palladium.createPalladium(world, blockpos, context.getHorizontalDirection().getOpposite());
                if (palladium == null) {
                    return InteractionResult.FAIL;
                }
                serverLevel.addFreshEntity((Entity)palladium);
                world.playSound(null, palladium.getX(), palladium.getY(), palladium.getZ(), SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                context.getPlayer().gameEvent((Holder)GameEvent.ENTITY_PLACE);
            }
            itemstack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.FAIL;
    }
}

