/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.client.screen.ScreenLoader;
import greekfantasy.util.Quest;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class QuestItem
extends Item {
    private static final String QUEST_NAME = "quest.name";
    public static final String KEY_QUEST = "QuestId";

    public QuestItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        if (worldIn.isClientSide()) {
            ScreenLoader.openQuestScreen(playerIn, playerIn.getInventory().selected, itemstack);
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public String getDescriptionId(ItemStack itemStack) {
        ResourceLocation questId;
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty() && customData.copyTag().contains(KEY_QUEST) && (questId = ResourceLocation.tryParse((String)customData.copyTag().getString(KEY_QUEST))) != null) {
            return Quest.getDescriptionFromKey(questId);
        }
        return super.getDescriptionId(itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"item.greekfantasy.quest.tooltip").withStyle(ChatFormatting.GRAY));
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return 67;
    }
}

