/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.Multimap;
import greekfantasy.entity.misc.Spear;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SpearItem
extends TieredItem {
    public static final ResourceLocation ATTACK_DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"spear_attack_damage");
    public static final ResourceLocation ATTACK_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"spear_attack_speed");
    public static final ResourceLocation ATTACK_RANGE_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"spear_attack_range");
    public static final String KEY_MOB_EFFECT = "Potion";
    protected Multimap<Holder<Attribute>, AttributeModifier> spearAttributes;
    protected final float attackRange;
    protected final int setFire;

    public SpearItem(Tier tier, Item.Properties properties) {
        this(tier, 0.25f, properties);
    }

    public SpearItem(Tier tier, float attackRange, Item.Properties properties) {
        this(tier, attackRange, properties, 0);
    }

    public SpearItem(Tier tier, float attackRange, Item.Properties properties, int setFire) {
        super(tier, properties);
        this.attackRange = attackRange;
        this.setFire = setFire;
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isFoil(ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return super.isFoil(stack) || !customData.isEmpty() && customData.copyTag().contains(KEY_MOB_EFFECT);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int duration) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int useDuration = this.getUseDuration(stack, entity) - duration;
        if (useDuration < 10) {
            return;
        }
        if (!world.isClientSide()) {
            this.throwSpear(world, player, stack);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    protected void throwSpear(Level world, Player thrower, ItemStack stack) {
        stack.hurtAndBreak(1, (LivingEntity)thrower, thrower.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        Spear spear = new Spear(world, (LivingEntity)thrower, stack, this.setFire);
        spear.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 2.25f, 1.0f);
        if (thrower.getAbilities().instabuild) {
            spear.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        } else {
            thrower.getInventory().removeItem(stack);
        }
        world.addFreshEntity((Entity)spear);
        world.playSound(null, (Entity)spear, (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getDamageValue() >= stack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity user) {
        CompoundTag nbt;
        MobEffect effect;
        stack.hurtAndBreak(1, user, EquipmentSlot.MAINHAND);
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty() && customData.copyTag().contains(KEY_MOB_EFFECT) && (effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.getOptional(ResourceLocation.parse((String)(nbt = customData.copyTag().getCompound(KEY_MOB_EFFECT).copy()).getString(KEY_MOB_EFFECT))).orElse(null)) != null) {
            nbt.putByte("Id", (byte)BuiltInRegistries.MOB_EFFECT.getId((Object)effect));
            MobEffectInstance effectInstance = MobEffectInstance.load((CompoundTag)nbt);
            if (effectInstance != null) {
                target.addEffect(effectInstance);
            }
        }
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if ((double)state.getDestroySpeed((BlockGetter)world, pos) != 0.0) {
            stack.hurtAndBreak(2, entity, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public int getEnchantmentValue() {
        return Math.max(1, super.getEnchantmentValue() / 2);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt;
        MobEffect potion;
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty() && customData.copyTag().contains(KEY_MOB_EFFECT) && (potion = (MobEffect)BuiltInRegistries.MOB_EFFECT.getOptional(ResourceLocation.parse((String)(nbt = customData.copyTag().getCompound(KEY_MOB_EFFECT).copy()).getString(KEY_MOB_EFFECT))).orElse(null)) != null) {
            int level = 1 + nbt.getInt("Amplifier");
            tooltip.add((Component)Component.translatable((String)potion.getDescriptionId()).append(" ").append((Component)Component.translatable((String)("enchantment.level." + level))).withStyle(ChatFormatting.GREEN));
        }
    }
}

