/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.misc.HealingSpell;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StaffOfHealingItem
extends Item {
    public StaffOfHealingItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getMaxDamage() - stack.getDamageValue() <= 1) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.getCooldowns().addCooldown((Item)this, ((Integer)GreekFantasy.CONFIG.STAFF_OF_HEALING_COOLDOWN.get()).intValue());
        if (!world.isClientSide()) {
            HealingSpell healingSpell = HealingSpell.create(world, (LivingEntity)player);
            world.addFreshEntity((Entity)healingSpell);
        }
        if (!player.isCreative()) {
            stack.hurtAndBreak(((Integer)GreekFantasy.CONFIG.STAFF_OF_HEALING_DURABILITY_ON_USE.get()).intValue(), (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return toRepair.getItem() == this && toRepair.getDamageValue() < toRepair.getMaxDamage() && repair.is((Item)GFRegistry.ItemReg.SNAKESKIN.get());
    }
}

