/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.entity.misc.ThrowingAxe;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ThrowingAxeItem
extends AxeItem {
    private static final int OPTIMAL_USE_DURATION = 25;

    public ThrowingAxeItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int duration) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!world.isClientSide()) {
            int useDuration = this.getUseDuration(stack, entity) - duration;
            float inaccuracy = 1.0f + 12.0f * (1.0f - Mth.clamp((float)((float)useDuration / 25.0f), (float)0.0f, (float)1.0f));
            ThrowingAxe throwingAxe = new ThrowingAxe(world, (LivingEntity)player, stack, !player.isCreative());
            throwingAxe.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.25f, inaccuracy);
            world.addFreshEntity((Entity)throwingAxe);
        }
        if (!player.isCreative()) {
            player.setItemInHand(player.getUsedItemHand(), ItemStack.EMPTY);
        }
        player.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.2f, 1.2f + world.getRandom().nextFloat() * 0.2f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }
}

