/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThunderboltItem
extends Item {
    public ThunderboltItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult raytrace;
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getMaxDamage() - stack.getDamageValue() <= 1) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isRaining() && !level.isThundering()) {
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".use.deny.rain")), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide() && (raytrace = ThunderboltItem.raytraceFromEntity((LivingEntity)player, 64.0f)).getType() != HitResult.Type.MISS) {
            LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
            bolt.setPos(raytrace.getLocation().x(), raytrace.getLocation().y(), raytrace.getLocation().z());
            level.addFreshEntity((Entity)bolt);
            int damageAmount = (Integer)GreekFantasy.CONFIG.THUNDERBOLT_DURABILITY_ON_USE.get();
            boolean fireflashLevel = false;
            boolean fireflash = false;
            player.getCooldowns().addCooldown((Item)this, (Integer)GreekFantasy.CONFIG.THUNDERBOLT_COOLDOWN.get() / 1);
            if (!player.isCreative() && damageAmount > 0) {
                stack.hurtAndBreak(damageAmount, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return toRepair.getItem() == this && toRepair.getDamageValue() < toRepair.getMaxDamage() && this.isRepairItem(repair);
    }

    private boolean isRepairItem(ItemStack repair) {
        return repair.getItem() == GFRegistry.ItemReg.ICHOR.get();
    }

    public static BlockHitResult raytraceFromEntity(LivingEntity player, float range) {
        return ThunderboltItem.raytraceFromEntity(player, range, ClipContext.Fluid.SOURCE_ONLY);
    }

    public static BlockHitResult raytraceFromEntity(LivingEntity player, float range, ClipContext.Fluid fluidMode) {
        Vec3 startVec = player.getEyePosition(1.0f);
        float pitch = (float)Math.toRadians(-player.getXRot());
        float yaw = (float)Math.toRadians(-player.getYRot());
        float cosYaw = Mth.cos((float)(yaw - (float)Math.PI));
        float sinYaw = Mth.sin((float)(yaw - (float)Math.PI));
        float cosPitch = -Mth.cos((float)pitch);
        float sinPitch = Mth.sin((float)pitch);
        Vec3 endVec = startVec.add((double)(sinYaw * cosPitch * range), (double)(sinPitch * range), (double)(cosYaw * cosPitch * range));
        return player.level().clip(new ClipContext(startVec, endVec, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }
}

