/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import greekfantasy.GreekFantasy;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ThyrsusItem
extends TieredItem {
    public static final ResourceLocation ATTACK_DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"thyrsus_attack_damage");
    public static final ResourceLocation ATTACK_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"thyrsus_attack_speed");
    private final float attackDamage;
    private final Multimap<Holder<Attribute>, AttributeModifier> defaultModifiers;

    public ThyrsusItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, properties);
        this.attackDamage = attackDamage + tier.getAttackDamageBonus();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ATTACK_DAMAGE_ID, (double)this.attackDamage, AttributeModifier.Operation.ADD_VALUE));
        builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE));
        this.defaultModifiers = builder.build();
    }

    public boolean hurtEnemy(ItemStack itemStack, LivingEntity target, LivingEntity owner) {
        itemStack.hurtAndBreak(1, owner, EquipmentSlot.MAINHAND);
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack mainhandItem = player.getItemInHand(hand);
        InteractionHand offhand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack offhandItem = player.getItemInHand(offhand);
        boolean success = false;
        if (offhandItem.is(Items.BUCKET)) {
            offhandItem.shrink(1);
            player.getInventory().add(new ItemStack((ItemLike)Items.MILK_BUCKET));
            success = true;
        }
        if (offhandItem.is(Items.GLASS_BOTTLE)) {
            offhandItem.shrink(1);
            ItemStack waterBottle = new ItemStack((ItemLike)Items.POTION);
            player.getInventory().add(waterBottle);
            success = true;
        }
        if (success) {
            player.getCooldowns().addCooldown((Item)this, ((Integer)GreekFantasy.CONFIG.THYRSUS_COOLDOWN.get()).intValue());
            if (!player.isCreative()) {
                mainhandItem.hurtAndBreak(((Integer)GreekFantasy.CONFIG.THYRSUS_DURABILITY_ON_USE.get()).intValue(), (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)mainhandItem, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")).withStyle(ChatFormatting.GRAY));
    }
}

