/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GreekFantasy;
import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class UnicornHornItem
extends Item {
    private final int useDuration = 50;
    private final int useCooldown = 240;

    public UnicornHornItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 50;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            player.getCooldowns().addCooldown((Item)this, 240);
        }
        if (((Boolean)GreekFantasy.CONFIG.UNICORN_HORN_CURES_EFFECTS.get()).booleanValue()) {
            HashSet<Holder> negativeEffects = new HashSet<Holder>();
            for (MobEffectInstance effectInstance : entityLiving.getActiveEffects()) {
                if (((MobEffect)effectInstance.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) continue;
                negativeEffects.add(effectInstance.getEffect());
            }
            for (Holder negativeEffect : negativeEffects) {
                entityLiving.removeEffect(negativeEffect);
            }
        }
        entityLiving.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 80, 0));
        stack.hurtAndBreak(((Integer)GreekFantasy.CONFIG.UNICORN_HORN_DURABILITY_ON_USE.get()).intValue(), entityLiving, EquipmentSlot.MAINHAND);
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

