/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import greekfantasy.GreekFantasy;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WingedSandalsItem
extends ArmorItem {
    public static final ResourceLocation SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"winged_sandals_speed");
    public static final int BROKEN = 2;
    private static final String TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/models/armor/winged_layer_2.png").toString();
    protected Multimap<Holder<Attribute>, AttributeModifier> attributeModifiers;

    public WingedSandalsItem(Holder<ArmorMaterial> armorMaterial, Item.Properties builderIn) {
        super(armorMaterial, ArmorItem.Type.BOOTS, builderIn);
        double speedBonus = 1.5;
        double stepHeightBonus = 0.62f;
        this.attributeModifiers = ImmutableMultimap.of();
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 22;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getItemBySlot(EquipmentSlot.FEET).is((Item)this) && stack.getMaxDamage() - stack.getDamageValue() > 2) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.JUMP, 30, 4, false, false, false));
            livingEntity.fallDistance = 0.0f;
            if ((double)level.getRandom().nextFloat() < GreekFantasy.CONFIG.getWingedSandalsDurabilityChance()) {
                stack.hurtAndBreak(1, livingEntity, EquipmentSlot.FEET);
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
    }

    public boolean isFoil(ItemStack stack) {
        return GreekFantasy.CONFIG.isOverstepEnabled() ? stack.isEnchanted() : super.isFoil(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.getMaxDamage() - stack.getDamageValue() <= 2) {
            tooltip.add((Component)Component.translatable((String)"item.tooltip.broken").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        tooltip.add((Component)Component.translatable((String)((MobEffect)MobEffects.JUMP.value()).getDescriptionId()).withStyle(ChatFormatting.AQUA).append(" ").append((Component)Component.translatable((String)"enchantment.level.5").withStyle(ChatFormatting.AQUA)));
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.parse((String)TEXTURE);
    }
}

