/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CPlayNotePacket(int entity, int note, SoundEvent sound, float volume) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CPlayNotePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"play_note"));
    public static final StreamCodec<FriendlyByteBuf, CPlayNotePacket> CODEC = StreamCodec.of(CPlayNotePacket::write, CPlayNotePacket::read);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void write(FriendlyByteBuf buf, CPlayNotePacket packet) {
        buf.writeInt(packet.entity);
        buf.writeInt(packet.note);
        buf.writeResourceLocation(BuiltInRegistries.SOUND_EVENT.getKey((Object)packet.sound));
        buf.writeFloat(packet.volume);
    }

    public static CPlayNotePacket read(FriendlyByteBuf buf) {
        int entity = buf.readInt();
        int note = buf.readInt();
        SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(buf.readResourceLocation());
        float volume = buf.readFloat();
        return new CPlayNotePacket(entity, note, sound, volume);
    }

    public static void handlePacket(CPlayNotePacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = (ServerLevel)player.level();
            Entity entity = level.getEntity(message.entity);
            if (null == entity) {
                entity = player;
            }
            int note = Mth.clamp((int)message.note, (int)0, (int)25);
            float volume = Mth.clamp((float)message.volume, (float)0.0f, (float)3.0f);
            float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
            double noteData = (float)Math.pow(2.0, (double)note / 24.0);
            level.sendParticles(player, (ParticleOptions)ParticleTypes.NOTE, true, entity.getX(), entity.getEyeY(), entity.getZ(), 0, 1.0, 0.0, 0.0, noteData);
            level.playSound(null, entity, message.sound, SoundSource.PLAYERS, volume, pitch);
        });
    }
}

