/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import greekfantasy.GFRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SCurseOfCircePacket(int entity, int duration) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SCurseOfCircePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"curse_of_circe"));
    public static final StreamCodec<ByteBuf, SCurseOfCircePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SCurseOfCircePacket::entity, (StreamCodec)ByteBufCodecs.INT, SCurseOfCircePacket::duration, SCurseOfCircePacket::new);

    public static SCurseOfCircePacket addEffect(int entity, int duration) {
        return new SCurseOfCircePacket(entity, duration);
    }

    public static SCurseOfCircePacket removeEffect(int entity) {
        return new SCurseOfCircePacket(entity, -1);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePacket(SCurseOfCircePacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            Entity entity = mc.level.getEntity(message.entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (message.duration > 0) {
                    livingEntity.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.CURSE_OF_CIRCE, message.duration));
                    livingEntity.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 0.9f + livingEntity.getRandom().nextFloat() * 0.2f);
                    if (livingEntity instanceof Mob) {
                        Mob mob = (Mob)livingEntity;
                        mob.setPersistenceRequired();
                    }
                } else {
                    livingEntity.removeEffect(GFRegistry.MobEffectReg.CURSE_OF_CIRCE);
                    livingEntity.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 0.9f + livingEntity.getRandom().nextFloat() * 0.2f);
                }
            }
        });
    }
}

