/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.network;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import greekfantasy.GreekFantasy;
import greekfantasy.util.Song;
import java.util.Map;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SSongPacket {
    protected static final Codec<Map<ResourceLocation, Song>> CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, Song.CODEC);
    protected Map<ResourceLocation, Song> data;

    public SSongPacket(Map<ResourceLocation, Song> data) {
        this.data = data;
        if (FMLEnvironment.dist != Dist.CLIENT) {
            GreekFantasy.SONG_MAP.clear();
            GreekFantasy.SONG_MAP.putAll(data);
        }
    }

    public static SSongPacket fromBytes(FriendlyByteBuf buf) {
        Map data = (Map)buf.readWithCodec((DynamicOps)NbtOps.INSTANCE, CODEC, NbtAccounter.unlimitedHeap());
        return new SSongPacket(data);
    }

    public static void toBytes(SSongPacket msg, FriendlyByteBuf buf) {
        buf.writeWithCodec((DynamicOps)NbtOps.INSTANCE, CODEC, msg.data);
    }

    public static void handlePacket(SSongPacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            GreekFantasy.SONG_MAP.clear();
            GreekFantasy.SONG_MAP.putAll(message.data);
        });
    }
}

