/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.GFRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.world.ModifiableStructureInfo;
import net.neoforged.neoforge.common.world.StructureModifier;

public class AddSpawnsStructureModifier
implements StructureModifier {
    public static final MapCodec<AddSpawnsStructureModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE, (Codec)Structure.DIRECT_CODEC).fieldOf("structures").forGetter(AddSpawnsStructureModifier::getStructures), (App)MobCategory.CODEC.fieldOf("category").forGetter(AddSpawnsStructureModifier::getCategory), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("spawn").forGetter(AddSpawnsStructureModifier::getSpawn)).apply((Applicative)builder, AddSpawnsStructureModifier::new));
    protected final HolderSet<Structure> structures;
    protected final MobCategory category;
    protected final MobSpawnSettings.SpawnerData spawn;

    public AddSpawnsStructureModifier(HolderSet<Structure> structures, MobCategory category, MobSpawnSettings.SpawnerData spawn) {
        this.structures = structures;
        this.category = category;
        this.spawn = spawn;
    }

    public HolderSet<Structure> getStructures() {
        return this.structures;
    }

    public MobCategory getCategory() {
        return this.category;
    }

    public MobSpawnSettings.SpawnerData getSpawn() {
        return this.spawn;
    }

    public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
        if (phase == StructureModifier.Phase.ADD && this.structures.contains(structure)) {
            builder.getStructureSettings().getOrAddSpawnOverrides(this.category).addSpawn(this.spawn);
        }
    }

    public MapCodec<? extends StructureModifier> codec() {
        return (MapCodec)GFRegistry.StructureModifierReg.ADD_SPAWNS_MODIFIER.get();
    }
}

