/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class BronzeScrapLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<BronzeScrapLootModifier>> CODEC_SUPPLIER = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> BronzeScrapLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.STRING.listOf().fieldOf("paths").forGetter(BronzeScrapLootModifier::getPaths)).and((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("item_tag").forGetter(BronzeScrapLootModifier::getItemTag)).and((App)IntProvider.CODEC.fieldOf("count").forGetter(BronzeScrapLootModifier::getCount)).apply((Applicative)inst, BronzeScrapLootModifier::new)));
    private final List<String> paths;
    private final TagKey<Item> itemTag;
    private final IntProvider count;

    protected BronzeScrapLootModifier(LootItemCondition[] conditionsIn, List<String> paths, TagKey<Item> itemTag, IntProvider count) {
        super(conditionsIn);
        this.paths = ImmutableList.copyOf(paths);
        this.itemTag = itemTag;
        this.count = count;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    public IntProvider getCount() {
        return this.count;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation lootTable = context.getQueriedLootTableId();
        boolean matchesPath = false;
        String lootTableName = lootTable.toString();
        for (String path : this.paths) {
            if (!lootTableName.contains(path)) continue;
            matchesPath = true;
            break;
        }
        if (!matchesPath) {
            return generatedLoot;
        }
        Optional items = BuiltInRegistries.ITEM.getTag(this.itemTag);
        if (items.isEmpty() || ((HolderSet.Named)items.get()).size() == 0) {
            return generatedLoot;
        }
        int n = this.count.sample(context.getRandom());
        for (int i = 0; i < n; ++i) {
            Optional<Item> item = ((HolderSet.Named)items.get()).getRandomElement(context.getRandom()).map(h -> (Item)h.value());
            if (!item.isPresent()) continue;
            generatedLoot.add((Object)new ItemStack((ItemLike)item.get()));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC_SUPPLIER.get();
    }
}

