/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CodecJsonDataManager<T>
extends SimpleJsonResourceReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Codec<T> codec;
    private final String folderName;
    protected Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();

    public CodecJsonDataManager(String folderName, Codec<T> codec) {
        this(folderName, codec, STANDARD_GSON);
    }

    public CodecJsonDataManager(String folderName, Codec<T> codec, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
    }

    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap newMap = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(error -> LOGGER.error("Failed to parse data json for {} due to: {}", (Object)key, error)).ifPresent(result -> newMap.put(key, result.getFirst()));
        }
        this.data = newMap;
        LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.data.size());
    }

    public <PACKET extends CustomPacketPayload> CodecJsonDataManager<T> subscribeAsSyncable(Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        NeoForge.EVENT_BUS.addListener(this.getDatapackSyncListener(packetFactory));
        return this;
    }

    private <PACKET extends CustomPacketPayload> Consumer<OnDatapackSyncEvent> getDatapackSyncListener(Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        return event -> {
            ServerPlayer player = event.getPlayer();
            CustomPacketPayload packet = (CustomPacketPayload)packetFactory.apply(this.data);
            if (player == null) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        };
    }
}

