/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.Elpis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MysteriousBoxManager {
    private static final List<ResourceLocation> functions = new ArrayList<ResourceLocation>();

    private static void loadFunctions(ServerFunctionManager manager) {
        manager.getFunctionNames().forEach(rl -> {
            if (rl.getNamespace().equals("greekfantasy") && rl.getPath().contains("mysterious_box")) {
                functions.add((ResourceLocation)rl);
            }
        });
    }

    private static Optional<CommandFunction<CommandSourceStack>> getRandomFunction(ServerFunctionManager manager, RandomSource rand) {
        if (functions.isEmpty()) {
            MysteriousBoxManager.loadFunctions(manager);
            if (functions.isEmpty()) {
                GreekFantasy.LOGGER.error("Tried to load functions for mysterious_box but none were found! What went wrong?");
                return Optional.empty();
            }
        }
        int index = rand.nextInt(functions.size());
        ResourceLocation rl = functions.get(index);
        return manager.get(rl);
    }

    public static boolean onBoxOpened(Level level, Player playerIn, BlockState state, BlockPos pos) {
        MinecraftServer server = level.getServer();
        if (server != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerFunctionManager manager = server.getFunctions();
            Optional<CommandFunction<CommandSourceStack>> function = MysteriousBoxManager.getRandomFunction(manager, serverLevel.getRandom());
            Vec3 vec = Vec3.atCenterOf((Vec3i)pos).add(0.0, 0.35, 0.0);
            if (function.isPresent()) {
                CommandSourceStack commandSource = manager.getGameLoopSender().withLevel(serverLevel).withEntity((Entity)playerIn).withPosition(vec).withPermission(4).withSuppressedOutput();
                manager.execute(function.get(), commandSource);
                if ((double)(level.getRandom().nextFloat() * 100.0f) < (Double)GreekFantasy.CONFIG.ELPIS_SPAWN_CHANCE.get()) {
                    MysteriousBoxManager.addElpis(level, pos);
                }
                return true;
            }
        }
        return false;
    }

    public static void addElpis(Level level, BlockPos pos) {
        Elpis entity = (Elpis)((EntityType)GFRegistry.EntityReg.ELPIS.get()).create(level);
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.85, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        entity.restrictTo(pos.above(), 8);
        level.addFreshEntity((Entity)entity);
    }
}

