/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;

public class Quest {
    public static final Quest EMPTY = new Quest("ERROR", List.of(), true);
    public static final Codec<Quest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("description", (Object)"").forGetter(Quest::getDescriptionId), (App)Codec.STRING.listOf().optionalFieldOf("components", List.of()).forGetter(Quest::getComponentsIds), (App)Codec.BOOL.optionalFieldOf("disabled", (Object)false).forGetter(Quest::isDisabled)).apply((Applicative)instance, Quest::new));
    private final String description;
    private final List<String> components;
    private final boolean disabled;

    public Quest(String description, List<String> components, boolean disabled) {
        this.description = description;
        this.components = ImmutableList.copyOf(components);
        this.disabled = disabled;
    }

    public String getDescriptionId() {
        return this.description;
    }

    public List<String> getComponentsIds() {
        return this.components;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public MutableComponent getDescription() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public List<MutableComponent> getComponents() {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (String id : this.getComponentsIds()) {
            list.add(Component.translatable((String)id));
        }
        return list;
    }

    public static String getDescriptionFromKey(ResourceLocation id) {
        return "quest." + id.getNamespace() + "." + id.getPath();
    }

    public static ResourceLocation getRandomQuestId(RandomSource rand) {
        Object[] keys = GreekFantasy.QUEST_MAP.keySet().toArray(new ResourceLocation[0]);
        for (int attempts = 0; attempts < 10; ++attempts) {
            ResourceLocation id = (ResourceLocation)Util.getRandom((Object[])keys, (RandomSource)rand);
            if (GreekFantasy.QUEST_MAP.getOrDefault(id, EMPTY).isDisabled()) continue;
            return id;
        }
        return ResourceLocation.withDefaultNamespace((String)"empty");
    }

    public static ItemStack createQuestItemStack(ResourceLocation questId) {
        ItemStack itemStack = new ItemStack((ItemLike)GFRegistry.ItemReg.QUEST.get());
        CompoundTag tag = new CompoundTag();
        tag.putString("QuestId", questId.toString());
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return itemStack;
    }
}

