/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.util.Quest;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class QuestLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<QuestLootModifier>> CODEC_SUPPLIER = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> QuestLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.STRING.listOf().fieldOf("paths").forGetter(QuestLootModifier::getPaths)).and((App)IntProvider.CODEC.fieldOf("count").forGetter(QuestLootModifier::getCount)).apply((Applicative)inst, QuestLootModifier::new)));
    private final List<String> paths;
    private final IntProvider count;

    protected QuestLootModifier(LootItemCondition[] conditionsIn, List<String> paths, IntProvider count) {
        super(conditionsIn);
        this.paths = ImmutableList.copyOf(paths);
        this.count = count;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public IntProvider getCount() {
        return this.count;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation lootTable = context.getQueriedLootTableId();
        boolean matchesPath = false;
        String lootTableName = lootTable.toString();
        for (String path : this.paths) {
            if (!lootTableName.contains(path)) continue;
            matchesPath = true;
            break;
        }
        if (!matchesPath) {
            return generatedLoot;
        }
        int n = this.count.sample(context.getRandom());
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack = Quest.createQuestItemStack(Quest.getRandomQuestId(context.getRandom()));
            generatedLoot.add((Object)itemStack);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC_SUPPLIER.get();
    }
}

