/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class ReplaceDropsLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<ReplaceDropsLootModifier>> CODEC_SUPPLIER = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> ReplaceDropsLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ItemStack.CODEC.fieldOf("itemstack").forGetter(ReplaceDropsLootModifier::getItemStack)).and((App)Codec.BOOL.optionalFieldOf("replace", (Object)true).forGetter(ReplaceDropsLootModifier::isReplace)).apply((Applicative)inst, ReplaceDropsLootModifier::new)));
    private final ItemStack itemStack;
    private final boolean replace;

    protected ReplaceDropsLootModifier(LootItemCondition[] conditionsIn, ItemStack itemStack, boolean replace) {
        super(conditionsIn);
        this.itemStack = itemStack;
        this.replace = replace;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isReplace() {
        return this.replace;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.itemStack.isEmpty()) {
            return generatedLoot;
        }
        if (this.isReplace()) {
            return ObjectArrayList.of((Object[])new ItemStack[]{this.itemStack.copy()});
        }
        generatedLoot.add((Object)this.itemStack.copy());
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC_SUPPLIER.get();
    }
}

