/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.GFRegistry;
import greekfantasy.util.WeightedMobEffectInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class SalveRecipe
extends ShapelessRecipe {
    private WeightedMobEffectInstance useEffect;
    private int bonusEffectCount;
    private List<WeightedMobEffectInstance> bonusEffects;
    private int rolls;

    public SalveRecipe(String group, WeightedMobEffectInstance useEffect, List<WeightedMobEffectInstance> bonusEffects, int rolls, NonNullList<Ingredient> recipeItemsIn) {
        super(group, CraftingBookCategory.MISC, SalveRecipe.createSalve(useEffect, bonusEffects, rolls), recipeItemsIn);
        this.useEffect = useEffect;
        this.bonusEffects = bonusEffects;
        this.bonusEffectCount = this.bonusEffects.size();
        this.rolls = rolls;
    }

    private static ItemStack createSalve(WeightedMobEffectInstance useEffect, List<WeightedMobEffectInstance> bonusEffects, int rolls) {
        ItemStack itemStack = new ItemStack((ItemLike)GFRegistry.ItemReg.OLIVE_SALVE.get());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("UseEffect", (Tag)useEffect.asTag());
        compoundTag.putInt("Rolls", rolls);
        ListTag list = new ListTag();
        for (WeightedMobEffectInstance instance : bonusEffects) {
            list.add((Object)instance.asTag());
        }
        compoundTag.put("BonusEffects", (Tag)list);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
        return itemStack;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack result = super.assemble(input, registries);
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)GFRegistry.RecipeReg.OLIVE_SALVE.get();
    }

    public WeightedMobEffectInstance getUseEffect() {
        return this.useEffect;
    }

    public List<WeightedMobEffectInstance> getBonusEffects() {
        return this.bonusEffects;
    }

    public int getRolls() {
        return this.rolls;
    }

    public int getBonusEffectCount() {
        return this.bonusEffectCount;
    }

    public static class Serializer
    implements RecipeSerializer<SalveRecipe> {
        public static final String CATEGORY = "olive_salve";
        private static final String KEY_USE_EFFECT = "use_effect";
        private static final String KEY_BONUS_EFFECTS = "bonus_effects";
        private static final String KEY_ROLLS = "rolls";
        private static final MapCodec<SalveRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.getGroup()), (App)WeightedMobEffectInstance.CODEC.fieldOf(KEY_USE_EFFECT).forGetter(SalveRecipe::getUseEffect), (App)WeightedMobEffectInstance.CODEC.listOf().fieldOf(KEY_BONUS_EFFECTS).forGetter(SalveRecipe::getBonusEffects), (App)Codec.INT.fieldOf(KEY_ROLLS).forGetter(SalveRecipe::getRolls), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for salve recipe");
            }
            if (ingredients.length > 9) {
                return DataResult.error(() -> "Too many ingredients for salve recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)instance, SalveRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SalveRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SalveRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SalveRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SalveRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            int ingredientCount = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)ingredientCount, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ing -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            int rolls = buffer.readInt();
            int bonusEffectCount = buffer.readInt();
            WeightedMobEffectInstance useEffect = WeightedMobEffectInstance.fromTag(buffer.readNbt());
            ArrayList<WeightedMobEffectInstance> bonusEffects = new ArrayList<WeightedMobEffectInstance>(bonusEffectCount);
            for (int i = 0; i < bonusEffectCount; ++i) {
                bonusEffects.add(WeightedMobEffectInstance.fromTag(buffer.readNbt()));
            }
            return new SalveRecipe(group, useEffect, bonusEffects, rolls, (NonNullList<Ingredient>)ingredients);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SalveRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            buffer.writeInt(recipe.getRolls());
            buffer.writeInt(recipe.getBonusEffectCount());
            buffer.writeNbt((Tag)recipe.getUseEffect().asTag());
            int n = recipe.getBonusEffectCount();
            for (int i = 0; i < n; ++i) {
                buffer.writeNbt((Tag)recipe.getBonusEffects().get(i).asTag());
            }
        }
    }
}

