/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class Song {
    public static final Song EMPTY = new Song("Error", "Error", 0, List.of(), List.of());
    public static final Codec<Song> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Song::getNameTranslationKey), (App)Codec.STRING.fieldOf("credits").forGetter(Song::getCreditsTranslationKey), (App)Codec.INT.fieldOf("interval").forGetter(Song::getInterval), (App)Codec.INT.listOf().fieldOf("treble").forGetter(Song::getTreble), (App)Codec.INT.listOf().fieldOf("bass").forGetter(Song::getBass)).apply((Applicative)instance, Song::new));
    private final String name;
    private final String credits;
    private final int interval;
    private final int length;
    private final List<Integer> treble;
    private final List<Integer> bass;

    protected Song(String name, String credits, int interval, List<Integer> treble, List<Integer> bass) {
        this.name = name;
        this.credits = credits;
        this.interval = interval;
        this.length = Math.max(treble.size(), bass.size());
        this.treble = treble;
        this.bass = bass;
    }

    public String getNameTranslationKey() {
        return this.name;
    }

    public String getCreditsTranslationKey() {
        return this.credits;
    }

    public Component getName() {
        return Component.translatable((String)this.getNameTranslationKey());
    }

    public Component getCredits() {
        return Component.translatable((String)this.getCreditsTranslationKey()).withStyle(ChatFormatting.ITALIC);
    }

    public int getInterval() {
        return this.interval;
    }

    public int getLength() {
        return this.length;
    }

    public List<Integer> getTreble() {
        return this.treble;
    }

    public List<Integer> getBass() {
        return this.bass;
    }

    public boolean shouldPlayNote(long worldTime) {
        return (int)(worldTime % (long)this.getInterval()) == 0;
    }

    public List<Integer> getTrebleNotes(long worldTime) {
        return Song.getNotes(this.treble, worldTime, this.getInterval(), this.length);
    }

    public List<Integer> getBassNotes(long worldTime) {
        return Song.getNotes(this.bass, worldTime, this.getInterval(), this.length);
    }

    public static List<Integer> getNotes(List<Integer> notes, long worldTime, int playSpeed, int maxLength) {
        int currentNote;
        ArrayList<Integer> noteSet = new ArrayList<Integer>();
        int currentIndex = Math.abs((int)(worldTime / (long)playSpeed)) % maxLength;
        int n = currentNote = currentIndex >= notes.size() ? 0 : Mth.clamp((int)notes.get(currentIndex), (int)0, (int)24);
        if (currentNote > 0) {
            noteSet.add(currentNote);
        }
        return noteSet;
    }
}

