/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import greekfantasy.GreekFantasy;
import greekfantasy.item.InstrumentItem;
import greekfantasy.network.CPlayNotePacket;
import greekfantasy.util.Song;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public final class SongManager {
    private SongManager() {
    }

    public static boolean playMusic(LivingEntity entity, InstrumentItem instrument, ResourceLocation songName, long worldTime, float volume, float volumeBass) {
        Optional<Song> song = Optional.ofNullable(GreekFantasy.SONG_MAP.get(songName));
        if (song.isPresent() && song.get().shouldPlayNote(worldTime)) {
            List<Integer> treble = song.get().getTrebleNotes(worldTime);
            List<Integer> bass = song.get().getBassNotes(worldTime);
            for (Integer note : treble) {
                SongManager.playNoteAt(entity, instrument, note, volume);
            }
            for (Integer note : bass) {
                SongManager.playNoteAt(entity, instrument, note, volumeBass);
            }
            return !treble.isEmpty() || !bass.isEmpty();
        }
        return false;
    }

    public static void playNoteAt(LivingEntity entity, InstrumentItem instrument, int note, float volume) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CPlayNotePacket(entity.getId(), note, instrument.getSound(), volume), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

