/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class SpawnRulesUtil {
    public static boolean checkMonsterSpawnRules(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        return level.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)rand) && Mob.checkMobSpawnRules(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)rand);
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<? extends PathfinderMob> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        return level.getDifficulty() != Difficulty.PEACEFUL && Mob.checkMobSpawnRules(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)rand);
    }

    public static boolean checkWaterMobSpawnRules(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        if (!level.getFluidState(pos.below()).is(FluidTags.WATER)) {
            return false;
        }
        boolean flag = mobSpawnType == MobSpawnType.SPAWNER || level.getFluidState(pos).is(FluidTags.WATER);
        return rand.nextInt(30) == 0 && SpawnRulesUtil.isDeepEnoughToSpawn((LevelAccessor)level, pos) && flag;
    }

    public static boolean checkSurfaceWaterMobSpawnRules(EntityType<? extends PathfinderMob> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        int seaLevel = level.getSeaLevel();
        int belowSeaLevel = seaLevel - 13;
        return pos.getY() >= belowSeaLevel && pos.getY() <= seaLevel && level.getFluidState(pos.below()).is(FluidTags.WATER) && level.getBlockState(pos.above()).is(Blocks.WATER);
    }

    public static boolean checkWaterMonsterSpawnRules(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        return level.getDifficulty() != Difficulty.PEACEFUL && SpawnRulesUtil.checkWaterMobSpawnRules(entityType, level, mobSpawnType, pos, rand);
    }

    private static boolean isDeepEnoughToSpawn(LevelAccessor level, BlockPos pos) {
        return pos.getY() < level.getSeaLevel() - 5;
    }
}

