/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import greekfantasy.GFRegistry;
import greekfantasy.entity.Automaton;
import greekfantasy.entity.boss.BronzeBull;
import greekfantasy.entity.boss.Cerberus;
import greekfantasy.entity.boss.Talos;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.phys.Vec3;

public final class SummonBossUtil {
    public static final TagKey<Block> BRONZE_BLOCK = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"storage_blocks/bronze"));
    public static final TagKey<Block> BRONZE_BLOCK_COMMON = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/bronze"));
    public static final TagKey<Block> COPPER_BLOCK = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"storage_blocks/any_copper"));
    public static final TagKey<Block> COPPER_BLOCK_COMMON = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/any_copper"));
    public static final TagKey<Block> COPPER_BLOCK_STORAGE = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"storage_blocks/copper"));
    public static final TagKey<Block> COPPER_BLOCK_STORAGE_COMMON = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/copper"));
    public static final TagKey<Block> CERBERUS_FRAME = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"cerberus_frame"));
    private static final BlockPattern cerberusPattern = BlockPatternBuilder.start().aisle(new String[]{"~##~", "~~~~", "~~~~"}).aisle(new String[]{"#^^#", "~OO~", "~OO~"}).aisle(new String[]{"#^^#", "~OO~", "~OO~"}).aisle(new String[]{"~##~", "~~~~", "~~~~"}).where('#', BlockInWorld.hasState(state -> state.is(CERBERUS_FRAME))).where('^', BlockInWorld.hasState(state -> state.is(Blocks.LAVA))).where('O', BlockInWorld.hasState(BlockBehaviour.BlockStateBase::isAir)).where('~', BlockInWorld.hasState(state -> true)).build();
    private static final BlockPattern automatonPattern = BlockPatternBuilder.start().aisle(new String[]{"^", "#"}).where('^', BlockInWorld.hasState(SummonBossUtil::isBronzeBlock)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)GFRegistry.BlockReg.ICHOR_INFUSED_GEARBOX.get())))).build();

    private static boolean isBronzeBlock(BlockState state) {
        return state.is(BRONZE_BLOCK) || state.is(BRONZE_BLOCK_COMMON) || state.is((Block)GFRegistry.BlockReg.BRONZE_BLOCK.get());
    }

    private static boolean isCopperBlock(BlockState state) {
        return state.is(COPPER_BLOCK) || state.is(COPPER_BLOCK_COMMON) || state.is(COPPER_BLOCK_STORAGE) || state.is(COPPER_BLOCK_STORAGE_COMMON) || SummonBossUtil.isVanillaCopperBlock(state);
    }

    public static boolean isSummonBlock(BlockState state) {
        return SummonBossUtil.isBronzeBlock(state) || SummonBossUtil.isCopperBlock(state);
    }

    private static boolean isCopperBaseBlock(BlockState state) {
        return SummonBossUtil.isCopperBlock(state) && !SummonBossUtil.isBronzeBlock(state);
    }

    private static boolean isVanillaCopperBlock(BlockState state) {
        return state.is(Blocks.COPPER_BLOCK) || state.is(Blocks.EXPOSED_COPPER) || state.is(Blocks.WEATHERED_COPPER) || state.is(Blocks.OXIDIZED_COPPER) || state.is(Blocks.CUT_COPPER) || state.is(Blocks.EXPOSED_CUT_COPPER) || state.is(Blocks.WEATHERED_CUT_COPPER) || state.is(Blocks.OXIDIZED_CUT_COPPER) || state.is(Blocks.WAXED_COPPER_BLOCK) || state.is(Blocks.WAXED_EXPOSED_COPPER) || state.is(Blocks.WAXED_WEATHERED_COPPER) || state.is(Blocks.WAXED_OXIDIZED_COPPER) || state.is(Blocks.WAXED_CUT_COPPER) || state.is(Blocks.WAXED_EXPOSED_CUT_COPPER) || state.is(Blocks.WAXED_WEATHERED_CUT_COPPER) || state.is(Blocks.WAXED_OXIDIZED_CUT_COPPER);
    }

    private static boolean isBronzeAt(Level level, BlockPos pos) {
        return SummonBossUtil.isBronzeBlock(level.getBlockState(pos));
    }

    private static boolean isCopperAt(Level level, BlockPos pos) {
        return SummonBossUtil.isCopperBlock(level.getBlockState(pos));
    }

    private static boolean isCopperBaseAt(Level level, BlockPos pos) {
        return SummonBossUtil.isCopperBaseBlock(level.getBlockState(pos));
    }

    private static boolean isCerberusBaseBlock(BlockState state) {
        return state.is(CERBERUS_FRAME) || state.is(Blocks.BLACKSTONE) || state.is(Blocks.POLISHED_BLACKSTONE) || state.is(Blocks.POLISHED_BLACKSTONE_BRICKS) || state.is(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS) || state.is(Blocks.CHISELED_POLISHED_BLACKSTONE) || state.is(Blocks.GILDED_BLACKSTONE);
    }

    @Nullable
    private static BlockPos findCerberusBase(Level level, BlockPos lavaPos) {
        int baseY = lavaPos.getY();
        for (int baseX = lavaPos.getX() - 3; baseX <= lavaPos.getX(); ++baseX) {
            for (int baseZ = lavaPos.getZ() - 3; baseZ <= lavaPos.getZ(); ++baseZ) {
                boolean headInCenter;
                boolean validStructure = true;
                block2: for (int dx = 0; dx < 4 && validStructure; ++dx) {
                    for (int dz = 0; dz < 4; ++dz) {
                        boolean isCenter;
                        BlockPos checkPos = new BlockPos(baseX + dx, baseY, baseZ + dz);
                        boolean bl = isCenter = dx >= 1 && dx <= 2 && dz >= 1 && dz <= 2;
                        if (isCenter) {
                            if (level.getBlockState(checkPos).is(Blocks.LAVA)) continue;
                            validStructure = false;
                            continue block2;
                        }
                        if (SummonBossUtil.isCerberusBaseBlock(level.getBlockState(checkPos))) continue;
                        validStructure = false;
                        continue block2;
                    }
                }
                if (!validStructure) continue;
                boolean bl = headInCenter = lavaPos.getX() >= baseX + 1 && lavaPos.getX() <= baseX + 2 && lavaPos.getZ() >= baseZ + 1 && lavaPos.getZ() <= baseZ + 2;
                if (!headInCenter) continue;
                return new BlockPos(baseX, baseY, baseZ);
            }
        }
        return null;
    }

    private static BlockPos[][] getBronzeBullHornPairsStrict(int baseX, int baseY, int baseZ) {
        int[] hornYs;
        ArrayList<BlockPos[]> pairs = new ArrayList<BlockPos[]>();
        for (int hornY : hornYs = new int[]{baseY + 1, baseY + 2}) {
            pairs.add(new BlockPos[]{new BlockPos(baseX, hornY, baseZ - 1), new BlockPos(baseX, hornY, baseZ + 2)});
            pairs.add(new BlockPos[]{new BlockPos(baseX + 1, hornY, baseZ - 1), new BlockPos(baseX + 1, hornY, baseZ + 2)});
            pairs.add(new BlockPos[]{new BlockPos(baseX - 1, hornY, baseZ), new BlockPos(baseX + 2, hornY, baseZ)});
            pairs.add(new BlockPos[]{new BlockPos(baseX - 1, hornY, baseZ + 1), new BlockPos(baseX + 2, hornY, baseZ + 1)});
        }
        return (BlockPos[][])pairs.toArray((T[])new BlockPos[0][]);
    }

    public static boolean onPlaceBronzeBlock(Level level, BlockPos pos, BlockState state, @Nullable Entity placer) {
        if (!SummonBossUtil.isBronzeBlock(state) && !SummonBossUtil.isCopperBlock(state)) {
            return false;
        }
        BlockPattern pattern = automatonPattern;
        BlockPattern.BlockPatternMatch helper = pattern.find((LevelReader)level, pos);
        if (helper != null) {
            for (int i = 0; i < pattern.getWidth(); ++i) {
                for (int j = 0; j < pattern.getHeight(); ++j) {
                    for (int k = 0; k < pattern.getDepth(); ++k) {
                        BlockInWorld cachedblockinfo1 = helper.getBlock(i, j, k);
                        level.destroyBlock(cachedblockinfo1.getPos(), false);
                    }
                }
            }
            Automaton.spawnAutomaton(level, helper.getBlock(0, 1, 0).getPos(), 0.0f);
            return true;
        }
        Player debugPlayer = null;
        if (placer instanceof Player) {
            Player placerPlayer = (Player)placer;
            if (level instanceof ServerLevel) {
                debugPlayer = placerPlayer;
            }
        }
        if (SummonBossUtil.trySummonTalos(level, pos, state, debugPlayer)) {
            return true;
        }
        boolean fallbackSummoned = SummonBossUtil.trySummonBronzeBullFallback(level, pos, state, debugPlayer);
        return fallbackSummoned;
    }

    private static boolean trySummonTalos(Level level, BlockPos pos, BlockState placedState, @Nullable Player debugPlayer) {
        BlockPos bronzePos;
        if (SummonBossUtil.isBronzeBlock(placedState)) {
            boolean summoned = SummonBossUtil.trySummonTalosFromBronze(level, pos);
            if (!summoned && debugPlayer != null) {
                SummonBossUtil.reportTalosFailure(level, debugPlayer, pos);
            }
            return summoned;
        }
        if (SummonBossUtil.isCopperBaseBlock(placedState) && SummonBossUtil.isBronzeAt(level, bronzePos = pos.above())) {
            boolean summoned = SummonBossUtil.trySummonTalosFromBronze(level, bronzePos);
            if (!summoned && debugPlayer != null) {
                SummonBossUtil.reportTalosFailure(level, debugPlayer, bronzePos);
            }
            return summoned;
        }
        return false;
    }

    private static boolean trySummonTalosFromBronze(Level level, BlockPos bronzePos) {
        return SummonBossUtil.trySummonTalosVertical(level, bronzePos);
    }

    private static boolean trySummonTalosVertical(Level level, BlockPos bronzePos) {
        int bronzeX = bronzePos.getX();
        int bronzeZ = bronzePos.getZ();
        int baseY = bronzePos.getY() - 2;
        for (int dx = 0; dx < 3; ++dx) {
            int baseX = bronzeX - dx;
            int baseZ = bronzeZ;
            if (SummonBossUtil.trySummonTalosVerticalAt(level, baseX, baseY, baseZ, true, bronzePos)) {
                return true;
            }
            baseX = bronzeX;
            baseZ = bronzeZ - dx;
            if (!SummonBossUtil.trySummonTalosVerticalAt(level, baseX, baseY, baseZ, false, bronzePos)) continue;
            return true;
        }
        return false;
    }

    private static boolean trySummonTalosVerticalAt(Level level, int baseX, int baseY, int baseZ, boolean alongX, BlockPos bronzePos) {
        BlockPos checkPos;
        int z;
        int x;
        int dy;
        int dx;
        boolean bronzeInFootprint = false;
        for (dx = 0; dx < 3; ++dx) {
            for (dy = 0; dy < 2; ++dy) {
                x = alongX ? baseX + dx : baseX;
                checkPos = new BlockPos(x, baseY + dy, z = alongX ? baseZ : baseZ + dx);
                if (checkPos.equals((Object)bronzePos)) {
                    if (!SummonBossUtil.isBronzeAt(level, checkPos)) {
                        return false;
                    }
                    bronzeInFootprint = true;
                    continue;
                }
                if (!SummonBossUtil.isCopperBaseAt(level, checkPos)) {
                    return false;
                }
                BlockPos topPos = checkPos.above();
                if (!topPos.equals((Object)bronzePos)) continue;
                bronzeInFootprint = true;
            }
        }
        for (dx = 0; dx < 3; ++dx) {
            for (dy = 0; dy < 2; ++dy) {
                x = alongX ? baseX + dx : baseX;
                checkPos = new BlockPos(x, baseY + dy, z = alongX ? baseZ : baseZ + dx);
                if (checkPos.equals((Object)bronzePos)) continue;
                level.destroyBlock(checkPos, false);
            }
        }
        level.destroyBlock(bronzePos, false);
        BlockPos spawnPos = new BlockPos(baseX + 1, baseY + 1, baseZ + (alongX ? 0 : 1));
        Talos.spawnTalos(level, spawnPos, 0.0f);
        return true;
    }

    private static void reportTalosFailure(Level level, Player player, BlockPos bronzePos) {
    }

    private static TalosMatchInfo getTalosBestCopperMatch(Level level, BlockPos bronzePos, int width, int depth) {
        int baseY = bronzePos.getY() - 1;
        int bronzeX = bronzePos.getX();
        int bronzeZ = bronzePos.getZ();
        int bestCount = 0;
        List<String> bestMismatches = List.of();
        for (int dx = 0; dx < width; ++dx) {
            for (int dz = 0; dz < depth; ++dz) {
                int baseX = bronzeX - dx;
                int baseZ = bronzeZ - dz;
                int count = 0;
                ArrayList<String> mismatches = new ArrayList<String>();
                for (int ix = 0; ix < width; ++ix) {
                    for (int iz = 0; iz < depth; ++iz) {
                        BlockPos checkPos = new BlockPos(baseX + ix, baseY, baseZ + iz);
                        if (SummonBossUtil.isCopperBaseAt(level, checkPos)) {
                            ++count;
                            continue;
                        }
                        if (mismatches.size() >= 3) continue;
                        BlockState state = level.getBlockState(checkPos);
                        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                        mismatches.add(checkPos.toShortString() + "=" + String.valueOf(key));
                    }
                }
                if (count <= bestCount) continue;
                bestCount = count;
                bestMismatches = mismatches;
            }
        }
        return new TalosMatchInfo(bestCount, bestMismatches);
    }

    private static boolean trySummonTalosAt(Level level, int baseX, int baseY, int baseZ, int width, int depth, BlockPos bronzePos) {
        int dz;
        int dx;
        boolean bronzeInFootprint = false;
        boolean bronzeInBaseLayer = false;
        for (dx = 0; dx < width; ++dx) {
            for (dz = 0; dz < depth; ++dz) {
                BlockPos basePos = new BlockPos(baseX + dx, baseY, baseZ + dz);
                if (basePos.equals((Object)bronzePos)) {
                    if (!SummonBossUtil.isBronzeAt(level, basePos)) {
                        return false;
                    }
                    bronzeInFootprint = true;
                    bronzeInBaseLayer = true;
                    continue;
                }
                if (!SummonBossUtil.isCopperBaseAt(level, basePos)) {
                    return false;
                }
                BlockPos topPos = basePos.above();
                if (!topPos.equals((Object)bronzePos)) continue;
                bronzeInFootprint = true;
            }
        }
        if (!bronzeInFootprint) {
            return false;
        }
        if (!bronzeInBaseLayer && !SummonBossUtil.isBronzeAt(level, bronzePos)) {
            return false;
        }
        for (dx = 0; dx < width; ++dx) {
            for (dz = 0; dz < depth; ++dz) {
                level.destroyBlock(new BlockPos(baseX + dx, baseY, baseZ + dz), false);
            }
        }
        if (!bronzeInBaseLayer) {
            level.destroyBlock(bronzePos, false);
        }
        BlockPos spawnPos = new BlockPos(baseX + width / 2, baseY + 1, baseZ + depth / 2);
        Talos.spawnTalos(level, spawnPos, 0.0f);
        return true;
    }

    private static boolean trySummonBronzeBullFallback(Level level, BlockPos pos, BlockState placedState, @Nullable Player player) {
        boolean placedIsBronze = SummonBossUtil.isBronzeBlock(placedState);
        boolean placedIsCopper = SummonBossUtil.isCopperBaseBlock(placedState);
        for (int baseY = pos.getY() - 2; baseY <= pos.getY(); ++baseY) {
            for (int baseX = pos.getX() - 2; baseX <= pos.getX() + 1; ++baseX) {
                for (int baseZ = pos.getZ() - 2; baseZ <= pos.getZ() + 1; ++baseZ) {
                    BlockPos[][] hornOptions;
                    BlockPos basePos = new BlockPos(baseX, baseY, baseZ);
                    BlockPos basePosX = new BlockPos(baseX + 1, baseY, baseZ);
                    BlockPos basePosZ = new BlockPos(baseX, baseY, baseZ + 1);
                    BlockPos basePosXZ = new BlockPos(baseX + 1, baseY, baseZ + 1);
                    BlockPos topBasePos = new BlockPos(baseX, baseY + 1, baseZ);
                    BlockPos topBasePosX = new BlockPos(baseX + 1, baseY + 1, baseZ);
                    BlockPos topBasePosZ = new BlockPos(baseX, baseY + 1, baseZ + 1);
                    BlockPos topBasePosXZ = new BlockPos(baseX + 1, baseY + 1, baseZ + 1);
                    if (!SummonBossUtil.isCopperBaseAt(level, basePos) || !SummonBossUtil.isCopperBaseAt(level, basePosX) || !SummonBossUtil.isCopperBaseAt(level, basePosZ) || !SummonBossUtil.isCopperBaseAt(level, basePosXZ) || !SummonBossUtil.isCopperBaseAt(level, topBasePos) || !SummonBossUtil.isCopperBaseAt(level, topBasePosX) || !SummonBossUtil.isCopperBaseAt(level, topBasePosZ) || !SummonBossUtil.isCopperBaseAt(level, topBasePosXZ)) continue;
                    for (BlockPos[] horns : hornOptions = SummonBossUtil.getBronzeBullHornPairsStrict(baseX, baseY, baseZ)) {
                        if (!SummonBossUtil.isBronzeAt(level, horns[0]) || !SummonBossUtil.isBronzeAt(level, horns[1]) || placedIsBronze && !horns[0].equals((Object)pos) && !horns[1].equals((Object)pos)) continue;
                        if (placedIsCopper) {
                            boolean placedInBase;
                            boolean bl = placedInBase = pos.equals((Object)basePos) || pos.equals((Object)basePosX) || pos.equals((Object)basePosZ) || pos.equals((Object)basePosXZ) || pos.equals((Object)topBasePos) || pos.equals((Object)topBasePosX) || pos.equals((Object)topBasePosZ) || pos.equals((Object)topBasePosXZ);
                            if (!placedInBase) continue;
                        }
                        level.destroyBlock(basePos, false);
                        level.destroyBlock(basePosX, false);
                        level.destroyBlock(basePosZ, false);
                        level.destroyBlock(basePosXZ, false);
                        level.destroyBlock(topBasePos, false);
                        level.destroyBlock(topBasePosX, false);
                        level.destroyBlock(topBasePosZ, false);
                        level.destroyBlock(topBasePosXZ, false);
                        level.destroyBlock(horns[0], false);
                        level.destroyBlock(horns[1], false);
                        Vec3 spawnPos = new Vec3((double)baseX + 1.0, (double)baseY + 0.1, (double)baseZ + 1.0);
                        BronzeBull.spawnBronzeBull(level, spawnPos, 0.0f);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean onOrthusHeadBurned(Level level, BlockPos pos, @Nullable UUID thrower) {
        BlockPos cerberusBase = SummonBossUtil.findCerberusBase(level, pos);
        if (cerberusBase != null) {
            for (int dx = 0; dx < 2; ++dx) {
                for (int dz = 0; dz < 2; ++dz) {
                    BlockPos lavaPos = cerberusBase.offset(1 + dx, 0, 1 + dz);
                    if (!level.getBlockState(lavaPos).is(Blocks.LAVA)) continue;
                    level.setBlock(lavaPos, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
                }
            }
            Cerberus.spawnCerberus(level, Vec3.atBottomCenterOf((Vec3i)pos.above()));
            return true;
        }
        BlockPattern pattern = cerberusPattern;
        BlockPattern.BlockPatternMatch helper = pattern.find((LevelReader)level, pos);
        if (helper == null) {
            block2: for (int dx = -2; dx <= 2; ++dx) {
                for (int dy = -2; dy <= 2; ++dy) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        helper = pattern.find((LevelReader)level, pos.offset(dx, dy, dz));
                        if (helper != null) break block2;
                    }
                }
            }
        }
        if (helper != null) {
            for (int i = 1; i < pattern.getWidth() - 1; ++i) {
                for (int k = 1; k < pattern.getDepth() - 1; ++k) {
                    BlockInWorld cachedblockinfo1 = helper.getBlock(i, 0, k);
                    level.setBlock(cachedblockinfo1.getPos(), Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
                }
            }
            Cerberus.spawnCerberus(level, Vec3.atBottomCenterOf((Vec3i)pos.above()));
            return true;
        }
        return false;
    }

    private static final class TalosMatchInfo {
        private final int matchCount;
        private final List<String> mismatches;

        private TalosMatchInfo(int matchCount, List<String> mismatches) {
            this.matchCount = matchCount;
            this.mismatches = mismatches;
        }
    }
}

