/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class WeightedMobEffectInstance
extends WeightedEntry.IntrusiveBase {
    public static final WeightedMobEffectInstance EMPTY = new WeightedMobEffectInstance((Holder<MobEffect>)MobEffects.REGENERATION, 0, 0, Weight.of((int)1));
    public static final String WEIGHT = "weight";
    public static final Codec<WeightedMobEffectInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("mob_effect").forGetter(WeightedMobEffectInstance::getMobEffectHolder), (App)Codec.INT.optionalFieldOf("duration", (Object)1).forGetter(WeightedMobEffectInstance::getDuration), (App)Codec.INT.optionalFieldOf("amplifier", (Object)1).forGetter(WeightedMobEffectInstance::getAmplifier), (App)Weight.CODEC.optionalFieldOf(WEIGHT, (Object)Weight.of((int)1)).forGetter(WeightedEntry.IntrusiveBase::getWeight)).apply((Applicative)instance, WeightedMobEffectInstance::new));
    private final MobEffectInstance effectInstance;

    public WeightedMobEffectInstance(Holder<MobEffect> effect, int duration, int amplifier, Weight weight) {
        this(new MobEffectInstance(effect, duration, amplifier), weight);
    }

    public WeightedMobEffectInstance(MobEffectInstance effect, Weight weight) {
        super(weight);
        this.effectInstance = new MobEffectInstance(effect);
    }

    public static WeightedMobEffectInstance fromTag(CompoundTag tag) {
        MobEffectInstance effectInstance;
        byte oldId;
        MobEffect effect;
        int weight = tag.getInt(WEIGHT);
        if (tag.contains("Id") && !tag.contains("id") && (effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.byId((int)(oldId = tag.getByte("Id")))) != null) {
            String effectId = BuiltInRegistries.MOB_EFFECT.getKey((Object)effect).toString();
            tag.putString("id", effectId);
        }
        if ((effectInstance = MobEffectInstance.load((CompoundTag)tag)) == null) {
            return EMPTY;
        }
        return new WeightedMobEffectInstance(effectInstance, Weight.of((int)weight));
    }

    public MobEffect getMobEffect() {
        return (MobEffect)this.effectInstance.getEffect().value();
    }

    public Holder<MobEffect> getMobEffectHolder() {
        return this.effectInstance.getEffect();
    }

    public int getDuration() {
        return this.effectInstance.getDuration();
    }

    public int getAmplifier() {
        return this.effectInstance.getAmplifier();
    }

    public MobEffectInstance createMobEffectInstance() {
        return new MobEffectInstance(this.effectInstance);
    }

    public CompoundTag asTag() {
        CompoundTag effectTag = new CompoundTag();
        effectTag.putString("id", BuiltInRegistries.MOB_EFFECT.getKey((Object)this.getMobEffect()).toString());
        effectTag.putByte("amplifier", (byte)this.getAmplifier());
        effectTag.putInt("duration", this.getDuration());
        effectTag.putInt(WEIGHT, this.getWeight().asInt());
        return effectTag;
    }
}

