/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.worldgen;

import com.mojang.serialization.MapCodec;
import greekfantasy.GFRegistry;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class CentaurStructureProcessor
extends StructureProcessor {
    public static final CentaurStructureProcessor PROCESSOR = new CentaurStructureProcessor();
    public static final MapCodec<CentaurStructureProcessor> CODEC = MapCodec.unit(() -> PROCESSOR);

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)GFRegistry.StructureProcessorReg.CENTAUR_PROCESSOR_HOLDER.get();
    }

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader level, BlockPos seedPos, StructureTemplate.StructureEntityInfo rawEntityInfo, StructureTemplate.StructureEntityInfo entityInfo, StructurePlaceSettings placementSettings, StructureTemplate template) {
        CompoundTag tag = entityInfo.nbt.copy();
        Optional entityType = EntityType.by((CompoundTag)tag);
        if (entityType.isPresent() && entityType.get() == GFRegistry.EntityReg.CENTAUR.get()) {
            long seed = placementSettings.getBoundingBox().hashCode();
            RandomSource random = RandomSource.create((long)seed);
            Variant variant = (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)random);
            Markings markings = Markings.values()[Mth.floor((double)(Math.random() * (double)Markings.values().length))];
            tag.putInt("Variant", variant.getId() & 0xFF | markings.getId() << 8 & 0xFF00);
            return new StructureTemplate.StructureEntityInfo(entityInfo.pos, entityInfo.blockPos, tag);
        }
        return entityInfo;
    }
}

