/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.worldgen;

import com.mojang.serialization.Codec;
import greekfantasy.GFRegistry;
import greekfantasy.entity.monster.Harpy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class HarpyNestFeature
extends Feature<TreeConfiguration> {
    public HarpyNestFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<TreeConfiguration> context) {
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        switch (context.random().nextInt(2)) {
            case 0: {
                return this.buildTallVariant(context, rotation);
            }
            case 1: {
                return this.buildShortVariant(context, rotation);
            }
        }
        return false;
    }

    public boolean buildTallVariant(FeaturePlaceContext<TreeConfiguration> context, Rotation rotation) {
        WorldGenLevel level = context.level();
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource rand = context.random();
        BlockPos.MutableBlockPos pos = context.origin().mutable();
        int dHeight = context.random().nextInt(3) - 1;
        int n = 14 + dHeight;
        for (int i = 0; i < n; ++i) {
            level.setBlock((BlockPos)pos, config.trunkProvider.getState(rand, (BlockPos)pos), 2);
            pos.move(Direction.UP, 1);
        }
        pos.setWithOffset((Vec3i)context.origin(), 0, dHeight, 0);
        level.setBlock(HarpyNestFeature.rot(pos.move(Direction.UP, 4), 0, 1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        level.setBlock(HarpyNestFeature.rot(pos.move(Direction.UP, 1), 0, 1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        level.setBlock(HarpyNestFeature.rot(pos, 0, 1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        pos.setWithOffset((Vec3i)context.origin(), 0, 3 + dHeight, 0);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 2);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 2);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, HarpyNestFeature.rot(pos.move(Direction.DOWN), 0, 2, rotation), config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, HarpyNestFeature.rot(pos, 0, 1, rotation), config.foliageProvider, 1);
        pos.setWithOffset((Vec3i)context.origin(), 0, 8 + dHeight, 0);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP, 2), config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 2);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 2);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 2);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 1);
        if (rand.nextBoolean()) {
            level.setBlock((BlockPos)pos.move(Direction.UP), config.foliageProvider.getState(rand, (BlockPos)pos), 2);
        }
        HarpyNestFeature.rot(pos.setWithOffset((Vec3i)context.origin(), 0, 6 + dHeight, 0), 0, 2, rotation);
        HarpyNestFeature.generateNestAround((LevelAccessor)level, (BlockPos)pos);
        HarpyNestFeature.addHarpy((ServerLevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP));
        if (rand.nextBoolean()) {
            HarpyNestFeature.addHarpy((ServerLevelAccessor)level, rand, (BlockPos)pos);
        }
        return true;
    }

    public boolean buildShortVariant(FeaturePlaceContext<TreeConfiguration> context, Rotation rotation) {
        int i;
        WorldGenLevel level = context.level();
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource rand = context.random();
        BlockPos.MutableBlockPos pos = context.origin().mutable();
        int dHeight = context.random().nextInt(3) - 1;
        int n = 6 + dHeight;
        for (i = 0; i < n; ++i) {
            level.setBlock((BlockPos)pos, config.trunkProvider.getState(rand, (BlockPos)pos), 2);
            pos.move(Direction.UP, 1);
        }
        pos.setWithOffset((Vec3i)context.origin(), 0, 4 + dHeight, 0);
        level.setBlock(HarpyNestFeature.rot(pos, 0, -1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        level.setBlock(HarpyNestFeature.rot(pos.move(Direction.UP), 0, -1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        pos.setWithOffset((Vec3i)context.origin(), 0, 4 + dHeight, 0);
        level.setBlock(HarpyNestFeature.rot(pos, 0, 1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        level.setBlock(HarpyNestFeature.rot(pos.move(Direction.UP), 0, 1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        pos.setWithOffset((Vec3i)context.origin(), 0, 4 + dHeight, 0);
        level.setBlock(HarpyNestFeature.rot(pos, -1, 0, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        level.setBlock(HarpyNestFeature.rot(pos.move(Direction.UP), -1, 0, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        level.setBlock(HarpyNestFeature.rot(pos, 0, -1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        level.setBlock(HarpyNestFeature.rot(pos.move(Direction.UP), -1, 1, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        pos.setWithOffset((Vec3i)context.origin(), 0, 5 + dHeight, 0);
        level.setBlock(HarpyNestFeature.rot(pos, 1, 0, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        level.setBlock(HarpyNestFeature.rot(pos, 1, 0, rotation), config.trunkProvider.getState(rand, (BlockPos)pos), 2);
        pos.setWithOffset((Vec3i)context.origin(), 0, 3 + dHeight, 0);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 2);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 3);
        pos.setWithOffset((Vec3i)context.origin(), 0, 5 + dHeight, 0);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, HarpyNestFeature.rot(pos, -2, 0, rotation), config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, HarpyNestFeature.rot(pos.move(Direction.UP), -1, 0, rotation), config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, HarpyNestFeature.rot(pos, 1, 1, rotation), config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, HarpyNestFeature.rot(pos, 0, -1, rotation), config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, HarpyNestFeature.rot(pos.move(Direction.DOWN), 0, -1, rotation), config.foliageProvider, 1);
        HarpyNestFeature.rot(pos.setWithOffset((Vec3i)context.origin(), 0, 5 + dHeight, 0), 2, 0, rotation);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos, config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 1);
        HarpyNestFeature.rot(pos.setWithOffset((Vec3i)context.origin(), 0, 6 + dHeight, 0), 0, -2, rotation);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos, config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 1);
        HarpyNestFeature.rot(pos.setWithOffset((Vec3i)context.origin(), 0, 6 + dHeight, 0), 0, 2, rotation);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos, config.foliageProvider, 1);
        HarpyNestFeature.generateLeavesAround((LevelAccessor)level, rand, (BlockPos)pos.move(Direction.UP), config.foliageProvider, 1);
        pos.setWithOffset((Vec3i)context.origin(), 0, 6 + dHeight, 0);
        HarpyNestFeature.generateNestAround((LevelAccessor)level, (BlockPos)pos);
        pos.move(Direction.UP);
        HarpyNestFeature.addHarpy((ServerLevelAccessor)level, rand, (BlockPos)pos);
        if (rand.nextBoolean()) {
            HarpyNestFeature.addHarpy((ServerLevelAccessor)level, rand, (BlockPos)pos);
        }
        HarpyNestFeature.rot(pos.move(Direction.DOWN, 2), -1, 1, rotation);
        for (i = 0; i < 3; ++i) {
            level.setBlock((BlockPos)pos.move(Direction.UP), config.foliageProvider.getState(rand, (BlockPos)pos), 3);
        }
        return true;
    }

    protected static BlockPos rot(BlockPos.MutableBlockPos origin, int x, int z, Rotation rot) {
        return origin.move((Vec3i)new BlockPos(x, 0, z).rotate(rot));
    }

    protected static boolean isReplaceableAt(LevelAccessor level, BlockPos pos) {
        return level.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.REPLACEABLE) || state.is(BlockTags.LEAVES));
    }

    protected static void generateLeavesAround(LevelAccessor level, RandomSource rand, BlockPos pos, BlockStateProvider leaf, int radius) {
        BlockPos.MutableBlockPos p = pos.mutable();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                p.setWithOffset((Vec3i)pos, x, 0, z);
                if (!HarpyNestFeature.shouldGenerateLeaf(x, z, radius, rand) || !HarpyNestFeature.isReplaceableAt(level, (BlockPos)p)) continue;
                level.setBlock((BlockPos)p, leaf.getState(rand, (BlockPos)p), 2);
            }
        }
    }

    protected static void generateNestAround(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos p = pos.mutable();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                p.setWithOffset((Vec3i)pos, x, 0, z);
                level.setBlock((BlockPos)p, ((Block)GFRegistry.BlockReg.NEST.get()).defaultBlockState(), 3);
                level.setBlock((BlockPos)p.move(Direction.UP), Blocks.AIR.defaultBlockState(), 2);
                level.setBlock((BlockPos)p.move(Direction.UP), Blocks.AIR.defaultBlockState(), 2);
            }
        }
    }

    protected static void addHarpy(ServerLevelAccessor level, RandomSource rand, BlockPos pos) {
        Harpy entity = (Harpy)((EntityType)GFRegistry.EntityReg.HARPY.get()).create((Level)level.getLevel());
        entity.moveTo((double)pos.getX() + rand.nextDouble(), (double)pos.getY() + 0.5, (double)pos.getZ() + rand.nextDouble(), 0.0f, 0.0f);
        entity.setPersistenceRequired();
        level.addFreshEntity((Entity)entity);
    }

    protected static boolean shouldGenerateLeaf(int x, int z, int radius, RandomSource rand) {
        return Math.abs(x) != radius || Math.abs(z) != radius || rand.nextInt(2) != 0;
    }
}

