/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.worldgen;

import com.mojang.serialization.MapCodec;
import greekfantasy.GFRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class LocStructureProcessor
extends StructureProcessor {
    public static final MapCodec<LocStructureProcessor> CODEC = RuleTest.CODEC.fieldOf("predicate").xmap(LocStructureProcessor::new, LocStructureProcessor::getLocPredicate);
    public static final LocStructureProcessor REQUIRE_AIR = new LocStructureProcessor((RuleTest)new BlockMatchTest(Blocks.AIR));
    private final RuleTest locPredicate;

    public LocStructureProcessor(RuleTest locPredicate) {
        this.locPredicate = locPredicate;
    }

    public RuleTest getLocPredicate() {
        return this.locPredicate;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos rawPos, BlockPos pos, StructureTemplate.StructureBlockInfo rawBlockInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        RandomSource random = placementSettings.getRandom(blockInfo.pos());
        BlockState blockState = level.getBlockState(blockInfo.pos());
        if (this.locPredicate.test(blockState, random)) {
            return blockInfo;
        }
        return null;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)GFRegistry.StructureProcessorReg.LOC_PROCESSOR_HOLDER.get();
    }
}

