/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.worldgen;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import greekfantasy.GFRegistry;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class OceanVillageStructureProcessor
extends StructureProcessor {
    public static final OceanVillageStructureProcessor PROCESSOR = new OceanVillageStructureProcessor();
    public static final MapCodec<OceanVillageStructureProcessor> CODEC = MapCodec.unit(() -> PROCESSOR);
    private static final Map<Block, List<Block>> CORAL_LIST = ImmutableMap.builder().put((Object)Blocks.HORN_CORAL_BLOCK, List.of(Blocks.HORN_CORAL_BLOCK, Blocks.FIRE_CORAL_BLOCK, Blocks.BUBBLE_CORAL_BLOCK, Blocks.BRAIN_CORAL_BLOCK, Blocks.TUBE_CORAL_BLOCK)).put((Object)Blocks.HORN_CORAL, List.of(Blocks.HORN_CORAL, Blocks.FIRE_CORAL, Blocks.BUBBLE_CORAL, Blocks.BRAIN_CORAL, Blocks.TUBE_CORAL)).put((Object)Blocks.HORN_CORAL_FAN, List.of(Blocks.HORN_CORAL_FAN, Blocks.FIRE_CORAL_FAN, Blocks.BUBBLE_CORAL_FAN, Blocks.BRAIN_CORAL_FAN, Blocks.TUBE_CORAL_FAN)).put((Object)Blocks.HORN_CORAL_WALL_FAN, List.of(Blocks.HORN_CORAL_WALL_FAN, Blocks.FIRE_CORAL_WALL_FAN, Blocks.BUBBLE_CORAL_WALL_FAN, Blocks.BRAIN_CORAL_WALL_FAN, Blocks.TUBE_CORAL_WALL_FAN)).build();
    private static final int coralListSize = List.copyOf(CORAL_LIST.values()).get(0).size();

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)GFRegistry.StructureProcessorReg.OCEAN_VILLAGE_PROCESSOR_HOLDER.get();
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos rawPos, BlockPos pos, StructureTemplate.StructureBlockInfo rawBlockInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        if (CORAL_LIST.containsKey(blockInfo.state().getBlock())) {
            long seed = placementSettings.getBoundingBox().hashCode();
            RandomSource random = RandomSource.create((long)seed);
            random.nextInt();
            int index = random.nextInt(coralListSize);
            Block mappedBlock = CORAL_LIST.get(blockInfo.state().getBlock()).get(index);
            BlockState replaced = OceanVillageStructureProcessor.copyMatchingProperties(blockInfo.state(), mappedBlock.defaultBlockState());
            return new StructureTemplate.StructureBlockInfo(blockInfo.pos(), replaced, blockInfo.nbt());
        }
        return blockInfo;
    }

    public static <BS extends StateHolder<?, BS>> BS copyMatchingProperties(BS from, BS to) {
        for (Property property : from.getProperties()) {
            if (!to.hasProperty(property)) continue;
            to = OceanVillageStructureProcessor.withGet(from, to, property);
        }
        return to;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S withGet(S from, S to, Property<T> property) {
        return (S)((StateHolder)to.setValue(property, from.getValue(property)));
    }
}

