/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.worldgen;

import com.mojang.serialization.Codec;
import greekfantasy.worldgen.LocStructureProcessor;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class OliveTreeFeature
extends Feature<TreeConfiguration> {
    private static final ResourceLocation[] OLIVE_TREES = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"olive_tree/olive_tree_0"), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"olive_tree/olive_tree_1"), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"olive_tree/olive_tree_2")};

    public OliveTreeFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<TreeConfiguration> context) {
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        StructureTemplateManager manager = context.level().getLevel().getStructureManager();
        StructureTemplate template = manager.getOrCreate((ResourceLocation)Util.getRandom((Object[])OLIVE_TREES, (RandomSource)context.random()));
        BlockPos offset = new BlockPos(-3, 0, -3);
        BlockPos pos = context.origin().offset((Vec3i)offset.rotate(rotation));
        BoundingBox mbb = new BoundingBox(pos.getX() - 8, pos.getY() - 16, pos.getZ() - 8, pos.getX() + 8, pos.getY() + 16, pos.getZ() + 8);
        StructurePlaceSettings placement = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror).setRandom(context.random()).setBoundingBox(mbb).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR).addProcessor((StructureProcessor)LocStructureProcessor.REQUIRE_AIR);
        template.placeInWorld((ServerLevelAccessor)context.level(), pos, pos, placement, context.random(), 2);
        return true;
    }
}

