/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.worldgen.maze;

import com.google.common.collect.ImmutableMap;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.worldgen.maze.Vector4i;
import greekfantasy.worldgen.maze.WeightedTemplate;
import greekfantasy.worldgen.maze.WeightedTemplateList;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class MazePiece
extends StructurePiece {
    private static final String KEY_OPENINGS = "Openings";
    private static final String KEY_VARIANT = "Variant";
    private static final String KEY_TEMPLATE = "Template";
    public static final int WIDTH = 6;
    public static final int HEIGHT = 7;
    public static final StructureProcessor AGE_PROCESSOR = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)GFRegistry.BlockReg.CRETAN_STONE_BRICK.get(), 0.44f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)GFRegistry.BlockReg.CRACKED_CRETAN_STONE_BRICK.get()).defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)GFRegistry.BlockReg.POLISHED_CRETAN_STONE.get(), 0.38f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)GFRegistry.BlockReg.CRACKED_POLISHED_CRETAN_STONE.get()).defaultBlockState())));
    public static final StructureProcessor PROTECTED_PROCESSOR = new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE);
    public static Map<Vector4i<Boolean>, ImmutablePair<Variant, Direction>> openingsMap = new HashMap<Vector4i<Boolean>, ImmutablePair<Variant, Direction>>();
    private Vector4i<Boolean> openings;
    private Variant variant;
    private ResourceLocation template;

    private static void add(boolean north, boolean east, boolean south, boolean west, Variant variant, Direction direction) {
        Vector4i<Boolean> vec = new Vector4i<Boolean>(north, east, south, west);
        openingsMap.put(vec, (ImmutablePair<Variant, Direction>)ImmutablePair.of((Object)((Object)variant), (Object)direction));
    }

    public MazePiece(Vector4i<Boolean> openings, Variant variant, Direction direction, int depth, BoundingBox boundingBox) {
        super((StructurePieceType)GFRegistry.StructureReg.MAZE_ROOM.get(), depth, boundingBox);
        this.openings = openings;
        this.variant = variant;
        this.setOrientation(direction);
    }

    public MazePiece(CompoundTag tag) {
        super((StructurePieceType)GFRegistry.StructureReg.MAZE_ROOM.get(), tag);
        this.variant = Variant.getByName(tag.getString(KEY_VARIANT));
        this.template = ResourceLocation.tryParse((String)tag.getString(KEY_TEMPLATE));
        ListTag wallTag = tag.getList(KEY_OPENINGS, 3);
        Vector4i<Boolean> vec = new Vector4i<Boolean>(false, false, false, false);
        if (wallTag.size() == 4) {
            int a = wallTag.getInt(0);
            int b = wallTag.getInt(1);
            int c = wallTag.getInt(2);
            int d = wallTag.getInt(3);
            vec = new Vector4i<Boolean>(a != 0, b != 0, c != 0, d != 0);
        }
        this.openings = vec;
    }

    public static MazePiece create(Vec3i origin, int x, int z) {
        return MazePiece.create(origin, x, 0, z);
    }

    public static MazePiece create(Vec3i origin, int x, int y, int z) {
        Vector4i<Boolean> vec = new Vector4i<Boolean>(false, false, false, false);
        Vec3i from = new Vec3i(origin.getX() + x * 6, origin.getY() + y * 7, origin.getZ() + z * 6);
        Vec3i to = new Vec3i(origin.getX() + (x + 1) * 6 - 1, origin.getY() + (y + 1) * 7, origin.getZ() + (z + 1) * 6 - 1);
        return new MazePiece(vec, Variant.NONE, Direction.NORTH, 0, BoundingBox.fromCorners((Vec3i)from, (Vec3i)to));
    }

    public MazePiece withVariant(Variant variant) {
        this.variant = variant;
        return this;
    }

    public MazePiece withDirection(Direction direction) {
        this.setOrientation(direction);
        return this;
    }

    public MazePiece withTemplate(ResourceLocation template) {
        this.template = template;
        return this;
    }

    public MazePiece withOpenings(boolean north, boolean east, boolean south, boolean west) {
        return this.withOpenings(new Vector4i<Boolean>(north, east, south, west));
    }

    public MazePiece withOpenings(Vector4i<Boolean> vec) {
        this.openings = vec;
        ImmutablePair<Variant, Direction> pair = openingsMap.get(vec);
        this.variant = (Variant)((Object)pair.getLeft());
        this.setOrientation((Direction)pair.getRight());
        return this;
    }

    public MazePiece deadEndOrRoom(RandomSource random, float roomChance) {
        if (this.variant == Variant.DEAD_END && random.nextFloat() < roomChance) {
            return this.withVariant(Variant.ROOM);
        }
        return this;
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.putString(KEY_VARIANT, this.variant.getSerializedName());
        if (this.template != null) {
            tag.putString(KEY_TEMPLATE, this.template.toString());
        }
    }

    public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (null == level.getServer()) {
            GreekFantasy.LOGGER.debug("[Maze] Failed to generate maze piece, server not found");
            return;
        }
        if (null == this.template) {
            GreekFantasy.LOGGER.debug("[Maze] No template defined for variant=" + String.valueOf((Object)this.variant) + " at " + String.valueOf(blockPos) + ". Did you forget to bake the piece?");
            return;
        }
        Optional oTemplateStructure = level.getServer().getStructureManager().get(this.template);
        if (!oTemplateStructure.isPresent()) {
            GreekFantasy.LOGGER.debug("[Maze] Failed to create structure template from " + String.valueOf(this.template));
            return;
        }
        StructureTemplate structureTemplate = (StructureTemplate)oTemplateStructure.get();
        Direction adjustedOrientation = Optional.ofNullable(this.getOrientation()).orElse(Direction.NORTH);
        int offsetX = 0;
        int offsetZ = 0;
        switch (adjustedOrientation) {
            case NORTH: {
                offsetX = -1;
                break;
            }
            case SOUTH: {
                offsetZ = -1;
                break;
            }
            case EAST: {
                offsetX = -1;
                offsetZ = -1;
                break;
            }
        }
        BlockPos origin = new BlockPos(this.getBoundingBox().minX() + offsetX + 1, this.getBoundingBox().minY(), this.getBoundingBox().minZ() + offsetZ + 1);
        BlockPos pivot = new BlockPos(structureTemplate.getSize().getX() / 2 - 1, 0, structureTemplate.getSize().getZ() / 2 - 1);
        StructurePlaceSettings placement = new StructurePlaceSettings().setRotationPivot(pivot).setRotation(this.getRotation()).setMirror(this.getMirror()).setRandom(random).setBoundingBox(this.getBoundingBox()).setFinalizeEntities(true).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK).addProcessor(PROTECTED_PROCESSOR).addProcessor(AGE_PROCESSOR);
        structureTemplate.placeInWorld((ServerLevelAccessor)level, origin, origin, placement, random, 2);
    }

    public Vector4i<Boolean> getOpenings() {
        return this.openings;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public ResourceLocation getTemplate() {
        return this.template;
    }

    public MazePiece bake(RandomSource random) {
        WeightedTemplateList templatePool = GreekFantasy.getMazePiece(this.variant.getTemplatePool());
        WeightedTemplate weightedTemplate = templatePool.sample(random);
        if (weightedTemplate != null) {
            this.template = weightedTemplate.getLocation();
        }
        return this;
    }

    public void setOrientation(@Nullable Direction direction) {
        Rotation newRotation;
        if (direction == null) {
            newRotation = Rotation.COUNTERCLOCKWISE_90;
        } else {
            switch (direction) {
                case SOUTH: {
                    newRotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case WEST: {
                    newRotation = Rotation.CLOCKWISE_180;
                    break;
                }
                case EAST: {
                    newRotation = Rotation.NONE;
                    break;
                }
                default: {
                    newRotation = Rotation.COUNTERCLOCKWISE_90;
                }
            }
        }
        try {
            Field orientationField = StructurePiece.class.getDeclaredField("orientation");
            orientationField.setAccessible(true);
            orientationField.set((Object)this, direction);
            Field mirrorField = StructurePiece.class.getDeclaredField("mirror");
            mirrorField.setAccessible(true);
            mirrorField.set((Object)this, Mirror.NONE);
            Field rotationField = StructurePiece.class.getDeclaredField("rotation");
            rotationField.setAccessible(true);
            rotationField.set((Object)this, newRotation);
        }
        catch (Exception e) {
            GreekFantasy.LOGGER.error("Failed to set orientation/mirror/rotation via reflection", (Throwable)e);
        }
    }

    static {
        MazePiece.add(false, false, false, false, Variant.NONE, Direction.NORTH);
        MazePiece.add(false, false, false, true, Variant.DEAD_END, Direction.EAST);
        MazePiece.add(false, false, true, false, Variant.DEAD_END, Direction.NORTH);
        MazePiece.add(false, false, true, true, Variant.CORNER, Direction.NORTH);
        MazePiece.add(false, true, false, false, Variant.DEAD_END, Direction.WEST);
        MazePiece.add(false, true, false, true, Variant.TWO_WAY, Direction.EAST);
        MazePiece.add(false, true, true, false, Variant.CORNER, Direction.WEST);
        MazePiece.add(false, true, true, true, Variant.THREE_WAY, Direction.NORTH);
        MazePiece.add(true, false, false, false, Variant.DEAD_END, Direction.SOUTH);
        MazePiece.add(true, false, false, true, Variant.CORNER, Direction.EAST);
        MazePiece.add(true, false, true, false, Variant.TWO_WAY, Direction.NORTH);
        MazePiece.add(true, false, true, true, Variant.THREE_WAY, Direction.EAST);
        MazePiece.add(true, true, false, false, Variant.CORNER, Direction.SOUTH);
        MazePiece.add(true, true, false, true, Variant.THREE_WAY, Direction.SOUTH);
        MazePiece.add(true, true, true, false, Variant.THREE_WAY, Direction.WEST);
        MazePiece.add(true, true, true, true, Variant.FOUR_WAY, Direction.NORTH);
    }

    public static enum Variant implements StringRepresentable
    {
        NONE("none"),
        DEAD_END("dead_end"),
        ROOM("room"),
        CORNER("corner"),
        TWO_WAY("two_way"),
        THREE_WAY("three_way"),
        FOUR_WAY("four_way"),
        BOSS_ROOM("boss_corner"),
        BOSS_ROOM_ENTRANCE("boss_corner_entrance"),
        LOWER_ENTRANCE("lower_entrance"),
        UPPER_ENTRANCE("upper_entrance"),
        UPPER_STAIRWAY("upper_stairway"),
        STAIRWAY("stairway");

        public static final Map<String, Variant> NAME_MAP;
        private final String name;
        private final ResourceLocation templatePool;

        private Variant(String name) {
            this.name = name;
            this.templatePool = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)name);
        }

        public ResourceLocation getTemplatePool() {
            return this.templatePool;
        }

        public static Variant getByName(String name) {
            return NAME_MAP.getOrDefault(name, NONE);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            NAME_MAP = ImmutableMap.copyOf(Arrays.stream(Variant.values()).collect(Collectors.toMap(Variant::getSerializedName, Function.identity())));
        }
    }
}

