/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.worldgen.maze;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import greekfantasy.GFRegistry;
import greekfantasy.worldgen.maze.MazePiece;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class MazeStructure
extends Structure {
    public static final int MAX_COUNT = 19;
    public static final MapCodec<MazeStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MazeStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)Codec.DOUBLE.optionalFieldOf("room_chance", (Object)0.5).forGetter(MazeStructure::getRoomChance), (App)Codec.INT.optionalFieldOf("piece_count_x", (Object)19).forGetter(MazeStructure::getPieceCountX), (App)Codec.INT.optionalFieldOf("piece_count_z", (Object)19).forGetter(MazeStructure::getPieceCountZ), (App)Codec.DOUBLE.optionalFieldOf("random_connection_ratio", (Object)0.0).forGetter(MazeStructure::getRandomConnectionRatio)).apply((Applicative)instance, MazeStructure::new));
    private final double roomChance;
    private final int pieceCountX;
    private final int pieceCountZ;
    private final double randomConnectionRatio;

    public MazeStructure(Structure.StructureSettings settings, double roomChance, int pieceCountX, int pieceCountZ, double randomConnectionRatio) {
        super(settings);
        this.roomChance = roomChance;
        this.pieceCountX = pieceCountX;
        this.pieceCountZ = pieceCountZ;
        this.randomConnectionRatio = randomConnectionRatio;
        if (pieceCountX < 2 || pieceCountX > 19) {
            throw new IllegalArgumentException("Error parsing maze configuration: piece_count_x must be between 2 and 19, inclusive.");
        }
        if (pieceCountZ < 2 || pieceCountZ > 19) {
            throw new IllegalArgumentException("Error parsing maze configuration: piece_count_z must be between 2 and 19, inclusive.");
        }
    }

    public double getRoomChance() {
        return this.roomChance;
    }

    public int getPieceCountX() {
        return this.pieceCountX;
    }

    public int getPieceCountZ() {
        return this.pieceCountZ;
    }

    public double getRandomConnectionRatio() {
        return this.randomConnectionRatio;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        context.random().nextDouble();
        ChunkPos chunkpos = context.chunkPos();
        BlockPos blockpos = new BlockPos(chunkpos.getMiddleBlockX(), 50, chunkpos.getMinBlockZ());
        StructurePiecesBuilder structurepiecesbuilder = new StructurePiecesBuilder();
        int offsetY = this.generatePiecesAndAdjust(structurepiecesbuilder, context);
        return Optional.of(new Structure.GenerationStub(blockpos.offset(0, offsetY, 0), Either.right((Object)structurepiecesbuilder)));
    }

    public StructureType<?> type() {
        return (StructureType)GFRegistry.StructureReg.MAZE.get();
    }

    private int generatePiecesAndAdjust(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int offsetY = context.random().nextIntBetweenInclusive(0, 78) - 16;
        List<MazePiece> pieces = this.generateMaze(context.chunkPos().getBlockAt(0, 0, 0), offsetY, context);
        for (MazePiece piece : pieces) {
            builder.addPiece((StructurePiece)piece);
        }
        builder.offsetPiecesVertically(offsetY);
        return offsetY;
    }

    public List<MazePiece> generateMaze(BlockPos origin, int offsetY, Structure.GenerationContext context) {
        WorldgenRandom rand = context.random();
        ArrayList<MazePiece> mazeRooms = new ArrayList<MazePiece>();
        MazePiece[][] tiles = new MazePiece[this.pieceCountX][this.pieceCountZ];
        boolean[][] visited = new boolean[this.pieceCountX][this.pieceCountZ];
        for (int i = 0; i < this.pieceCountX; ++i) {
            for (int j = 0; j < this.pieceCountZ; ++j) {
                tiles[i][j] = MazePiece.create((Vec3i)origin, i, j);
            }
        }
        int bX = this.pieceCountX / 2;
        int bY = this.pieceCountZ / 2;
        bX += rand.nextInt(bX / 2) - bX / 4;
        bY += rand.nextInt(bY / 2) - bY / 4;
        tiles[bX][bY - 1].withOpenings(false, false, true, false);
        tiles[bX][bY].withOpenings(false, true, true, false).withVariant(MazePiece.Variant.BOSS_ROOM_ENTRANCE).withDirection(Direction.WEST);
        tiles[bX + 1][bY].withOpenings(false, true, false, true).withVariant(MazePiece.Variant.BOSS_ROOM).withDirection(Direction.NORTH);
        tiles[bX][bY + 1].withOpenings(true, true, false, false).withVariant(MazePiece.Variant.BOSS_ROOM).withDirection(Direction.SOUTH);
        tiles[bX + 1][bY + 1].withOpenings(true, false, false, true).withVariant(MazePiece.Variant.BOSS_ROOM).withDirection(Direction.EAST);
        visited[bX + 1][bY + 1] = true;
        visited[bX][bY + 1] = true;
        visited[bX + 1][bY] = true;
        visited[bX][bY] = true;
        int n = (int)Math.floor((double)(this.pieceCountX * this.pieceCountZ) * this.randomConnectionRatio);
        for (int i = 0; i < n; ++i) {
            Point p1 = new Point(1 + rand.nextInt(this.pieceCountX - 2), 1 + rand.nextInt(this.pieceCountZ - 2));
            Point p2 = MazeStructure.unvisited(p1, visited, this.pieceCountX, this.pieceCountZ, (RandomSource)rand);
            if (p2 == null) continue;
            MazeStructure.connect(p1, p2, tiles);
        }
        MazeStructure.depthFirst(new Point(bX, bY - 1), visited, tiles, this.pieceCountX, this.pieceCountZ, (RandomSource)rand);
        Point startW = new Point(0, this.pieceCountZ / 2 + rand.nextInt(this.pieceCountZ / 2) - this.pieceCountZ / 4);
        mazeRooms.addAll(MazeStructure.entrance(context, origin, startW, offsetY, tiles[startW.x][startW.y], Direction.WEST));
        Point startN = new Point(this.pieceCountX / 2 + rand.nextInt(this.pieceCountX / 2) - this.pieceCountX / 4, 0);
        mazeRooms.addAll(MazeStructure.entrance(context, origin, startN, offsetY, tiles[startN.x][startN.y], Direction.NORTH));
        Point startE = new Point(this.pieceCountX - 1, this.pieceCountZ / 2 + rand.nextInt(this.pieceCountZ / 2) - this.pieceCountZ / 4);
        mazeRooms.addAll(MazeStructure.entrance(context, origin, startE, offsetY, tiles[startE.x][startE.y], Direction.EAST));
        Point startS = new Point(this.pieceCountX / 2 + rand.nextInt(this.pieceCountX / 2) - this.pieceCountX / 4, this.pieceCountZ - 1);
        mazeRooms.addAll(MazeStructure.entrance(context, origin, startS, offsetY, tiles[startS.x][startS.y], Direction.SOUTH));
        float roomProbability = (float)this.roomChance;
        for (int i = 0; i < this.pieceCountX; ++i) {
            for (int j = 0; j < this.pieceCountZ; ++j) {
                mazeRooms.add(tiles[i][j].deadEndOrRoom((RandomSource)rand, roomProbability).bake((RandomSource)rand));
            }
        }
        return mazeRooms;
    }

    private static Collection<MazePiece> entrance(Structure.GenerationContext context, BlockPos origin, Point vertex, int offsetY, MazePiece piece, Direction direction) {
        ArrayList<MazePiece> pieces = new ArrayList<MazePiece>();
        piece.withOpenings((Boolean)piece.getOpenings().a != false || direction == Direction.NORTH, (Boolean)piece.getOpenings().b != false || direction == Direction.EAST, (Boolean)piece.getOpenings().c != false || direction == Direction.SOUTH, (Boolean)piece.getOpenings().d != false || direction == Direction.WEST);
        Direction dOpposite = direction.getOpposite();
        Point point = new Point(vertex.x + direction.getStepX(), vertex.y + direction.getStepZ());
        MazePiece lowerEntrance = MazePiece.create((Vec3i)origin, point.x, point.y).withVariant(MazePiece.Variant.LOWER_ENTRANCE).withDirection(dOpposite).bake((RandomSource)context.random());
        pieces.add(lowerEntrance);
        BlockPos pos = lowerEntrance.getBoundingBox().getCenter();
        int height = context.chunkGenerator().getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        int count = (height - offsetY) / 7;
        for (int i = 1; i < count; ++i) {
            MazePiece stairway = MazePiece.create((Vec3i)origin, point.x, i, point.y).withVariant(MazePiece.Variant.STAIRWAY).withDirection(dOpposite).bake((RandomSource)context.random());
            pieces.add(stairway);
        }
        MazePiece upperEntrance = MazePiece.create((Vec3i)origin, point.x, count, point.y).withVariant(MazePiece.Variant.UPPER_ENTRANCE).withDirection(dOpposite).bake((RandomSource)context.random());
        pieces.add(upperEntrance);
        return pieces;
    }

    private static void depthFirst(Point vertex, boolean[][] visited, MazePiece[][] tiles, int pieceCountX, int pieceCountZ, RandomSource rand) {
        visited[vertex.x][vertex.y] = true;
        Point next = MazeStructure.unvisited(vertex, visited, pieceCountX, pieceCountZ, rand);
        while (next != null) {
            MazeStructure.connect(vertex, next, tiles);
            MazeStructure.depthFirst(next, visited, tiles, pieceCountX, pieceCountZ, rand);
            next = MazeStructure.unvisited(vertex, visited, pieceCountX, pieceCountZ, rand);
        }
    }

    @Nullable
    private static Point unvisited(Point vertex, boolean[][] visited, int pieceCountX, int pieceCountZ, RandomSource rand) {
        ArrayList<Point> neighborList = new ArrayList<Point>();
        if (vertex.x < pieceCountX - 1) {
            neighborList.add(new Point(vertex.x + 1, vertex.y));
        }
        if (vertex.y < pieceCountZ - 1) {
            neighborList.add(new Point(vertex.x, vertex.y + 1));
        }
        if (vertex.x > 0) {
            neighborList.add(new Point(vertex.x - 1, vertex.y));
        }
        if (vertex.y > 0) {
            neighborList.add(new Point(vertex.x, vertex.y - 1));
        }
        if (!neighborList.isEmpty()) {
            MazeStructure.shuffle(neighborList, rand);
            for (Point p : neighborList) {
                if (visited[p.x][p.y]) continue;
                return p;
            }
        }
        return null;
    }

    private static void connect(Point p1, Point p2, MazePiece[][] tiles) {
        if (p1.x == p2.x && p1.y > p2.y) {
            MazePiece temp = tiles[p1.x][p1.y];
            temp.withOpenings(true, (Boolean)temp.getOpenings().b, (Boolean)temp.getOpenings().c, (Boolean)temp.getOpenings().d);
            temp = tiles[p2.x][p2.y];
            temp.withOpenings((Boolean)temp.getOpenings().a, (Boolean)temp.getOpenings().b, true, (Boolean)temp.getOpenings().d);
        } else if (p1.x < p2.x && p1.y == p2.y) {
            MazePiece temp = tiles[p1.x][p1.y];
            temp.withOpenings((Boolean)temp.getOpenings().a, true, (Boolean)temp.getOpenings().c, (Boolean)temp.getOpenings().d);
            temp = tiles[p2.x][p2.y];
            temp.withOpenings((Boolean)temp.getOpenings().a, (Boolean)temp.getOpenings().b, (Boolean)temp.getOpenings().c, true);
        } else if (p1.x == p2.x && p1.y < p2.y) {
            MazePiece temp = tiles[p1.x][p1.y];
            temp.withOpenings((Boolean)temp.getOpenings().a, (Boolean)temp.getOpenings().b, true, (Boolean)temp.getOpenings().d);
            temp = tiles[p2.x][p2.y];
            temp.withOpenings(true, (Boolean)temp.getOpenings().b, (Boolean)temp.getOpenings().c, (Boolean)temp.getOpenings().d);
        } else if (p1.x > p2.x && p1.y == p2.y) {
            MazePiece temp = tiles[p1.x][p1.y];
            temp.withOpenings((Boolean)temp.getOpenings().a, (Boolean)temp.getOpenings().b, (Boolean)temp.getOpenings().c, true);
            temp = tiles[p2.x][p2.y];
            temp.withOpenings((Boolean)temp.getOpenings().a, true, (Boolean)temp.getOpenings().c, (Boolean)temp.getOpenings().d);
        }
    }

    private static void shuffle(List<?> list, RandomSource rnd) {
        int size;
        for (int i = size = list.size(); i > 1; --i) {
            Collections.swap(list, i - 1, rnd.nextInt(i));
        }
    }
}

