/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tyzsskills.init;

import net.mcreator.tyzsskills.potion.ControlMobEffect;
import net.mcreator.tyzsskills.potion.InvulnerabilityMobEffect;
import net.mcreator.tyzsskills.potion.X10MobEffect;
import net.mcreator.tyzsskills.potion.X5MobEffect;
import net.mcreator.tyzsskills.procedures.InvulnerabilityQuandLeffetExpireProcedure;
import net.mcreator.tyzsskills.procedures.X10QuandLeffetExpireProcedure;
import net.mcreator.tyzsskills.procedures.X5QuandLeffetExpireProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class TyzsSkillsModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"tyzs_skills");
    public static final DeferredHolder<MobEffect, MobEffect> CONTROL = REGISTRY.register("control", () -> new ControlMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INVULNERABILITY = REGISTRY.register("invulnerability", () -> new InvulnerabilityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> XP_MULTIPLIER_X5 = REGISTRY.register("xp_multiplier_x5", () -> new X5MobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> X_10 = REGISTRY.register("x_10", () -> new X10MobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TyzsSkillsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TyzsSkillsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(INVULNERABILITY)) {
            InvulnerabilityQuandLeffetExpireProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(XP_MULTIPLIER_X5)) {
            X5QuandLeffetExpireProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(X_10)) {
            X10QuandLeffetExpireProcedure.execute(entity);
        }
    }
}

