/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills;

import com.mojang.logging.LogUtils;
import com.tyzsskills.Config;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.active.ErrorManager;
import com.tyzsskills.server.active.FileManager;
import com.tyzsskills.server.active.SoundRegistry;
import com.tyzsskills.server.attachments.BlockMarker;
import com.tyzsskills.server.attachments.ExplorationProgression;
import com.tyzsskills.server.attachments.LegacyData;
import com.tyzsskills.server.attachments.StatsTracker;
import com.tyzsskills.server.commands.MainCommand;
import com.tyzsskills.server.events.RuntimeEvents;
import com.tyzsskills.server.events.SkillEffectsEvents;
import com.tyzsskills.server.events.XpGainsEvents;
import com.tyzsskills.server.payloads.CActionSkillPayload;
import com.tyzsskills.server.payloads.ConfigSyncPayload;
import com.tyzsskills.server.payloads.LevelDataUpdatePayload;
import com.tyzsskills.server.payloads.LevelToastPayload;
import com.tyzsskills.server.payloads.LevelUpdatePayload;
import com.tyzsskills.server.payloads.PowerUpdatePayload;
import com.tyzsskills.server.payloads.SkillBookmarksPayload;
import com.tyzsskills.server.payloads.SkillLevelSyncPayload;
import com.tyzsskills.server.payloads.SkillSyncPayload;
import com.tyzsskills.server.payloads.SkillTriggerPayload;
import com.tyzsskills.server.payloads.SpUpdatePayload;
import com.tyzsskills.server.payloads.StatsSpEarnedPayload;
import com.tyzsskills.server.payloads.StatsSpSpentPayload;
import com.tyzsskills.server.payloads.StatsXpPayload;
import com.tyzsskills.server.payloads.XpUpdatePayload;
import com.tyzsskills.server.skills.SkillBehaviourRegistry;
import com.tyzsskills.server.skills.SkillManager;
import com.tyzsskills.server.xp.XpManager;
import com.tyzsskills.server.xp.xpEvents.XpBlock;
import com.tyzsskills.server.xp.xpEvents.XpEntity;
import java.io.IOException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="tyzs_skills")
public class Tyzsskills {
    public static final String MODID = "tyzs_skills";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Tyzsskills(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        AttributeRegistry.ATTRIBUTES.register(modEventBus);
        modEventBus.addListener(this::RegisterAttributes);
        BlockMarker.ATTACHMENT_TYPES.register(modEventBus);
        LegacyData.ATTACHMENT_TYPES.register(modEventBus);
        ExplorationProgression.ATTACHMENT_TYPES.register(modEventBus);
        StatsTracker.ATTACHMENT_TYPES.register(modEventBus);
        SoundRegistry.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register(RuntimeEvents.class);
        NeoForge.EVENT_BUS.register(XpGainsEvents.class);
        NeoForge.EVENT_BUS.register(SkillEffectsEvents.class);
        modEventBus.addListener(this::RegisterPayloads);
        NeoForge.EVENT_BUS.addListener(RegisterCommandsEvent.class, this::RegisterCommands);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        SkillBehaviourRegistry.Init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void RegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(MainCommand.register());
    }

    private void RegisterAttributes(EntityAttributeModificationEvent event) {
        if (!event.has(EntityType.PLAYER, AttributeRegistry.SKILL_XP_MULTIPLIER)) {
            event.add(EntityType.PLAYER, AttributeRegistry.SKILL_XP_MULTIPLIER);
        }
        if (!event.has(EntityType.PLAYER, AttributeRegistry.SP_MULTIPLIER)) {
            event.add(EntityType.PLAYER, AttributeRegistry.SP_MULTIPLIER);
        }
        if (!event.has(EntityType.PLAYER, AttributeRegistry.TRAIT_POWER)) {
            event.add(EntityType.PLAYER, AttributeRegistry.TRAIT_POWER);
        }
    }

    private void RegisterPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(LevelUpdatePayload.TYPE, LevelUpdatePayload.STREAM_CODEC, LevelUpdatePayload::Handle);
        registrar.playToClient(SpUpdatePayload.TYPE, SpUpdatePayload.STREAM_CODEC, SpUpdatePayload::Handle);
        registrar.playToClient(XpUpdatePayload.TYPE, XpUpdatePayload.STREAM_CODEC, XpUpdatePayload::Handle);
        registrar.playToClient(LevelDataUpdatePayload.TYPE, LevelDataUpdatePayload.STREAM_CODEC, LevelDataUpdatePayload::Handle);
        registrar.playToClient(SkillSyncPayload.TYPE, SkillSyncPayload.STREAM_CODEC, SkillSyncPayload::Handle);
        registrar.playToClient(SkillLevelSyncPayload.TYPE, SkillLevelSyncPayload.STREAM_CODEC, SkillLevelSyncPayload::Handle);
        registrar.playToClient(ConfigSyncPayload.TYPE, ConfigSyncPayload.STREAM_CODEC, ConfigSyncPayload::Handle);
        registrar.playToServer(CActionSkillPayload.TYPE, CActionSkillPayload.STREAM_CODEC, CActionSkillPayload::Handle);
        registrar.playToClient(SkillTriggerPayload.TYPE, SkillTriggerPayload.STREAM_CODEC, SkillTriggerPayload::Handle);
        registrar.playToClient(LevelToastPayload.TYPE, LevelToastPayload.STREAM_CODEC, LevelToastPayload::Handle);
        registrar.playToClient(SkillBookmarksPayload.TYPE, SkillBookmarksPayload.STREAM_CODEC, SkillBookmarksPayload::Handle);
        registrar.playToClient(PowerUpdatePayload.TYPE, PowerUpdatePayload.STREAM_CODEC, PowerUpdatePayload::Handle);
        registrar.playToClient(StatsXpPayload.TYPE, StatsXpPayload.STREAM_CODEC, StatsXpPayload::Handle);
        registrar.playToClient(StatsSpEarnedPayload.TYPE, StatsSpEarnedPayload.STREAM_CODEC, StatsSpEarnedPayload::Handle);
        registrar.playToClient(StatsSpSpentPayload.TYPE, StatsSpSpentPayload.STREAM_CODEC, StatsSpSpentPayload::Handle);
    }

    @SubscribeEvent
    public void OnServerBeforeStart(ServerAboutToStartEvent event) throws IOException {
        FileManager fileManager = FileManager.Get();
        MinecraftServer server = event.getServer();
        fileManager.InitPath(server);
        fileManager.LoadDefaultJson(server);
        fileManager.LoadDefaultXpValues(server);
        fileManager.LoadDefaulltLevelPool(server);
        fileManager.ReadJsons(server);
        fileManager.ReadXpValues(server);
        fileManager.ReadLevelPool(server);
        fileManager.ReadCustomSkills(server);
    }

    @SubscribeEvent
    public void OnServerStop(ServerStoppingEvent event) {
        SkillManager.Get().ClearSkills();
        XpBlock.ClearValues();
        XpEntity.ClearValues();
        XpManager.ClearPool();
        ErrorManager.ClearErrors();
    }
}

