/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills;

import com.tyzsskills.Config;
import com.tyzsskills.Tyzsskills;
import com.tyzsskills.client.ClientCache;
import com.tyzsskills.client.key.MainKeybind;
import com.tyzsskills.client.models.InventoryButton;
import com.tyzsskills.client.screen.LevelTriggerOverlay;
import com.tyzsskills.client.screen.MainGUI;
import com.tyzsskills.client.screen.SkillTriggerOverlay;
import com.tyzsskills.client.screen.XpTriggerOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@Mod(value="tyzs_skills", dist={Dist.CLIENT})
@EventBusSubscriber(modid="tyzs_skills", value={Dist.CLIENT})
public class TyzsskillsClient {
    public TyzsskillsClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"skill_notification"), (LayeredDraw.Layer)new SkillTriggerOverlay());
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"xp_notification"), (LayeredDraw.Layer)new XpTriggerOverlay());
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"level_notification"), (LayeredDraw.Layer)new LevelTriggerOverlay());
    }

    @SubscribeEvent
    public static void onClientLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientCache.ClearCache();
        SkillTriggerOverlay.Clear();
        XpTriggerOverlay.Clear();
        Tyzsskills.LOGGER.info("CACHE CLEARED");
    }

    @SubscribeEvent
    public static void RegisterKeys(RegisterKeyMappingsEvent event) {
        event.register(MainKeybind.OPEN_SKILL_KEY);
    }

    @SubscribeEvent
    public static void OnClientTick(ClientTickEvent.Post event) {
        while (MainKeybind.OPEN_SKILL_KEY.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new MainGUI());
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof InventoryScreen || event.getScreen() instanceof CreativeModeInventoryScreen) {
            boolean overlap;
            if (!((Boolean)Config.SHOW_SKILL_BUTTON.get()).booleanValue()) {
                return;
            }
            AbstractContainerScreen screen = (AbstractContainerScreen)event.getScreen();
            int savedX = (Integer)Config.INVENTORY_BUTTON_X.get();
            int savedY = (Integer)Config.INVENTORY_BUTTON_Y.get();
            InventoryButton myButton = new InventoryButton(savedX, savedY, () -> Minecraft.getInstance().setScreen((Screen)new MainGUI()));
            if (savedX == 10 && savedY == 10 && (overlap = event.getListenersList().stream().filter(l -> l instanceof AbstractWidget).map(l -> (AbstractWidget)l).anyMatch(w -> w.getX() < savedX + 20 && w.getX() + w.getWidth() > savedX && w.getY() < savedY + 20 && w.getY() + w.getHeight() > savedY))) {
                myButton.setX(screen.getGuiLeft() + screen.getXSize() + 5);
                myButton.setY(screen.getGuiTop() + 5);
            }
            event.addListener((GuiEventListener)myButton);
        }
    }
}

