/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client;

import com.tyzsskills.Config;
import com.tyzsskills.client.screen.XpTriggerOverlay;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.Trait;
import com.tyzsskills.server.xp.XpManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ClientCache {
    private static int clientLevel = 1;
    private static int clientSP = 0;
    private static float clientXP = 0.0f;
    private static int clientPower = 0;
    private static float clientAllTimeXP = 0.0f;
    private static float clientSessionXP = 0.0f;
    private static int clientSpEarned = 0;
    private static int clientSpSpent = 0;
    private static int clienOwnedSkills = 0;
    private static XpManager.LevelData clientLevelData = new XpManager.LevelData(100.0f, 1);
    private static final Map<String, Skill> clientSkills = new HashMap<String, Skill>();
    private static final Map<String, Integer> clientSkillLevels = new HashMap<String, Integer>();
    private static final Map<String, Object> clientConfigMap = new HashMap<String, Object>();
    private static final Map<String, Boolean> clientBookmarks = new HashMap<String, Boolean>();
    private static Skill.ContainerType currentContainerType = Skill.ContainerType.SKILLS;
    private static Skill.CategoryType currentContainerCatgory = Skill.CategoryType.ALL;

    public static void UpdateClientCacheLevel(int level) {
        clientLevel = level;
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Client Level Update: " + level)), false);
        }
    }

    public static void UpdateClientCacheSP(int sp) {
        clientSP = sp;
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Client SP Update: " + sp)), false);
        }
    }

    public static void UpdateClientCachePower(int power) {
        clientPower = power;
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Client Power Update: " + power)), false);
        }
    }

    public static void UpdateClientCacheXP(float xp, float gained) {
        if (gained > 0.0f) {
            XpTriggerOverlay.AddXp(gained);
            clientSessionXP += gained;
        }
        clientXP = xp;
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Client XP Update: " + xp)), false);
        }
    }

    public static void UpdateClientStatXP(float amount) {
        if (amount > 0.0f) {
            clientAllTimeXP += amount;
        }
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Client XP stats Update"), false);
        }
    }

    public static void UpdateClientStatSpEarned(int amount) {
        if (amount > 0) {
            clientSpEarned += amount;
        }
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Client SP e stats Update"), false);
        }
    }

    public static void UpdateClientStatSpSpent(int amount) {
        if (amount > 0) {
            clientSpSpent += amount;
        }
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Client SP s stats Update"), false);
        }
    }

    public static void UpdateClientCacheLevelData(XpManager.LevelData data) {
        clientLevelData = data;
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Client LevelData Update: " + data.goal() + "xp, " + data.reward() + "sp")), false);
        }
    }

    public static void SetContainerType(Skill.ContainerType type) {
        if (!ClientCache.GetConfigBool("trait_system", true) && type == Skill.ContainerType.TRAITS) {
            return;
        }
        if (ClientCache.GetConfigInt("trait_unlock", 20) > clientLevel && type == Skill.ContainerType.TRAITS) {
            return;
        }
        currentContainerType = type;
    }

    public static void SetCategoryType(Skill.CategoryType category) {
        if (!ClientCache.GetConfigBool("trait_system", true) && category == Skill.CategoryType.TRAITS) {
            return;
        }
        if (ClientCache.GetConfigInt("trait_unlock", 20) > clientLevel && category == Skill.CategoryType.TRAITS) {
            return;
        }
        currentContainerCatgory = category;
    }

    public static void UpdateSkills(List<Skill> skills) {
        clientSkills.clear();
        for (Skill skill : skills) {
            clientSkills.put(skill.GetID(), skill);
        }
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Client skills sync: " + clientSkills.size() + " skills cached")), false);
        }
    }

    public static void UpdateSkillLevels(String id, int lvl) {
        clientSkillLevels.put(id.toLowerCase(), lvl);
        int owned = 0;
        for (Skill skill : clientSkills.values()) {
            if (skill instanceof Trait || !clientSkillLevels.containsKey(skill.GetID().toLowerCase())) continue;
            owned += clientSkillLevels.get(skill.GetID().toLowerCase()).intValue();
        }
        clienOwnedSkills = owned;
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("New skill level: " + id + " level " + lvl)), false);
        }
    }

    public static void SyncConfig(Map<String, Object> syncedMap) {
        clientConfigMap.clear();
        clientConfigMap.putAll(syncedMap);
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Synced config: " + clientConfigMap.size() + " entries")), false);
        }
    }

    public static void SyncBookmark(String id, boolean state) {
        clientBookmarks.put(id.toLowerCase(), state);
        if (((Boolean)Config.SHOW_DEBUG_MESSAGES.get()).booleanValue()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Synced bookmark: " + id + ": " + state)), false);
        }
    }

    public static void ClearCache() {
        clientLevel = 1;
        clientSP = 0;
        clientXP = 0.0f;
        clientPower = 0;
        clientLevelData = new XpManager.LevelData(100.0f, 1);
        clientSkills.clear();
        clientSkillLevels.clear();
        clientConfigMap.clear();
        clientBookmarks.clear();
        clientSessionXP = 0.0f;
        clientAllTimeXP = 0.0f;
        clientSpEarned = 0;
        clientSpSpent = 0;
        currentContainerCatgory = Skill.CategoryType.ALL;
        currentContainerType = Skill.ContainerType.SKILLS;
    }

    public static void PredictBookmark(Skill skill) {
        String id;
        boolean value = ClientCache.GetBookmarkState(id = skill.GetID());
        clientBookmarks.put(id, !value);
    }

    public static void PredictBuy(Skill skill) {
        String id = skill.GetID().toLowerCase();
        int currentLvl = ClientCache.GetSkillLevel(id);
        if (skill instanceof Trait) {
            if (!ClientCache.GetConfigBool("trait_system", true)) {
                return;
            }
            if (clientLevel < ClientCache.GetConfigInt("trait_unlock", 20)) {
                return;
            }
        }
        if (currentLvl >= skill.GetMaximumLevel()) {
            return;
        }
        List<Integer> prices = skill.GetPrices();
        if (currentLvl >= prices.size()) {
            return;
        }
        int price = prices.get(currentLvl);
        clientSP -= price;
        ClientCache.UpdateSkillLevels(id, currentLvl + 1);
        if (skill instanceof Trait) {
            Trait trait = (Trait)skill;
            clientPower += trait.getPowerWeight();
        }
    }

    public static void PredictRefund(Skill skill) {
        String id = skill.GetID().toLowerCase();
        int currentLvl = ClientCache.GetSkillLevel(id);
        if (skill instanceof Trait) {
            if (!ClientCache.GetConfigBool("trait_system", true)) {
                return;
            }
            if (clientLevel < ClientCache.GetConfigInt("trait_unlock", 20)) {
                return;
            }
        }
        if (currentLvl <= 0) {
            return;
        }
        ClientCache.UpdateSkillLevels(id, currentLvl - 1);
        double percentage = ClientCache.GetConfigDouble("refund_percentage", 0.0);
        List<Integer> prices = skill.GetPrices();
        if (currentLvl - 1 < prices.size()) {
            int initialPrice = prices.get(currentLvl - 1);
            int refundAmount = Math.max(1, (int)((double)initialPrice * (percentage / 100.0)));
            clientSP += refundAmount;
            if (skill instanceof Trait) {
                Trait trait = (Trait)skill;
                clientPower -= trait.getPowerWeight();
            }
        }
    }

    public static float GetXP() {
        return clientXP;
    }

    public static int GetSP() {
        return clientSP;
    }

    public static int GetLvl() {
        return clientLevel;
    }

    public static float GetXPGOAL() {
        return clientLevelData.goal();
    }

    public static float GetReward() {
        return clientLevelData.reward();
    }

    public static Skill.ContainerType GetContainerType() {
        return currentContainerType;
    }

    public static Skill.CategoryType GetCategoryType() {
        return currentContainerCatgory;
    }

    public static List<Skill> GetAllSkills() {
        return new ArrayList<Skill>(clientSkills.values());
    }

    public static int GetSkillLevel(String id) {
        return clientSkillLevels.getOrDefault(id.toLowerCase(), 0);
    }

    public static Skill GetSkill(String id) {
        return clientSkills.getOrDefault(id.toLowerCase(), null);
    }

    public static boolean GetBookmarkState(String id) {
        return clientBookmarks.getOrDefault(id.toLowerCase(), false);
    }

    public static int GetPower() {
        return clientPower;
    }

    public static float GetAllTimeXp() {
        return clientAllTimeXP;
    }

    public static float GetSessionXp() {
        return clientSessionXP;
    }

    public static int GetSpEarned() {
        return clientSpEarned;
    }

    public static int GetSpSpent() {
        return clientSpSpent;
    }

    public static int GetUnlockedSkills() {
        return clienOwnedSkills;
    }

    public static int GetSkillCount() {
        int count = 0;
        for (Skill skill : clientSkills.values()) {
            if (skill instanceof Trait) continue;
            count += skill.GetMaximumLevel();
        }
        return count;
    }

    public static boolean GetConfigBool(String id, boolean fallback) {
        Object value = clientConfigMap.get(id);
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        return fallback;
    }

    public static double GetConfigDouble(String id, double fallback) {
        Object value = clientConfigMap.get(id);
        if (value instanceof Double) {
            Double dbl = (Double)value;
            return dbl;
        }
        if (value instanceof Number) {
            Number nbr = (Number)value;
            return nbr.doubleValue();
        }
        return fallback;
    }

    public static int GetConfigInt(String id, int fallback) {
        Object value = clientConfigMap.get(id);
        if (value instanceof Integer) {
            Integer nbr = (Integer)value;
            return nbr;
        }
        return fallback;
    }

    public static int ParseColor(String hexString, int fallback) {
        if (hexString == null || hexString.isEmpty()) {
            return fallback;
        }
        try {
            Object clean = hexString.replace("#", "");
            if (((String)clean).length() == 6) {
                clean = "FF" + (String)clean;
            }
            return (int)Long.parseLong((String)clean, 16);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }
}

