/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client;

import com.tyzsskills.Config;
import com.tyzsskills.client.ClientCache;
import com.tyzsskills.server.model.Skill;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;

@EventBusSubscriber(modid="tyzs_skills", value={Dist.CLIENT})
public class FovHandler {
    @SubscribeEvent
    public static void onComputeFov(ComputeFovModifierEvent event) {
        double reduction = (Double)Config.FOV_REDUCTION.get();
        if (reduction <= 1.0E-4) {
            return;
        }
        List affectedSkills = (List)Config.FOV_AFFECTED_SKILLS.get();
        float totalDampening = 0.0f;
        for (String rawId : affectedSkills) {
            Skill skill;
            String id = rawId.toLowerCase();
            int level = ClientCache.GetSkillLevel(id);
            if (level <= 0 || (skill = ClientCache.GetSkill(id)) == null || skill.GetValues().isEmpty()) continue;
            int index = Math.min(level - 1, skill.GetValues().size() - 1);
            float rawValue = skill.GetValues().get(index).floatValue();
            float realFactor = rawValue / 100.0f;
            totalDampening += (float)((double)realFactor * reduction * 0.5);
        }
        if (totalDampening > 0.0f) {
            float currentFov = event.getFovModifier();
            float newFov = currentFov - totalDampening;
            if (currentFov >= 1.0f) {
                event.setNewFovModifier(Math.max(1.0f, newFov));
            }
        }
    }
}

