/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client.models;

import com.tyzsskills.client.models.SkillEntry;
import com.tyzsskills.client.models.SkillWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CustomScrollView
extends ObjectSelectionList<Entry> {
    private final ResourceLocation texture;
    private final int textureW;
    private final int textureH;
    private final int uScroll;
    private final int vScroll;
    private final int uScrollHover;
    private final int vScrollHover;
    private final int scrollWidth;
    private final int scrollHeight;
    private boolean isScrolling = false;
    private double scrollClickOffset = 0.0;

    public CustomScrollView(Minecraft minecraft, int x, int y, int width, int height, int itemHeight, ResourceLocation texture, int textureW, int textureH, int uScroll, int vScroll, int uScrollHover, int vScrollHover, int scrollWidth, int scrollHeight) {
        super(minecraft, width, height, y, itemHeight);
        this.setX(x);
        this.texture = texture;
        this.textureW = textureW;
        this.textureH = textureH;
        this.uScroll = uScroll;
        this.vScroll = vScroll;
        this.uScrollHover = uScrollHover;
        this.vScrollHover = vScrollHover;
        this.scrollWidth = scrollWidth;
        this.scrollHeight = scrollHeight;
        this.setRenderHeader(false, 0);
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        gui.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        this.renderListItems(gui, mouseX, mouseY, partialTick);
        gui.disableScissor();
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int scrollBarX = this.getScrollbarPosition();
            int scrollBarY = this.getScrollBarTop();
            boolean isHoveringBar = mouseX >= scrollBarX && mouseX < scrollBarX + this.scrollWidth && mouseY >= scrollBarY && mouseY < scrollBarY + this.scrollHeight;
            int currentU = this.uScroll;
            int currentV = this.vScroll;
            if (isHoveringBar || this.isScrolling) {
                currentU = this.uScrollHover;
                currentV = this.vScrollHover;
            }
            gui.blit(this.texture, scrollBarX, scrollBarY, (float)currentU, (float)currentV, this.scrollWidth, this.scrollHeight, this.textureW, this.textureH);
        }
    }

    public void clearEntries() {
        super.clearEntries();
    }

    public void AddEntry(SkillEntry entry) {
        super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public SkillWidget getHoveredWidget(int mouseX, int mouseY) {
        Entry entry = (Entry)this.getEntryAtPosition(mouseX, mouseY);
        if (entry instanceof SkillEntry) {
            SkillEntry skillEntry = (SkillEntry)entry;
            return skillEntry.getHoveredWidget(mouseX, mouseY);
        }
        return null;
    }

    private int getScrollBarTop() {
        int maxScroll = this.getMaxScroll();
        if (maxScroll <= 0) {
            return this.getY();
        }
        int barTop = this.getY() + (int)((float)this.getScrollAmount() * (float)(this.height - this.scrollHeight) / (float)maxScroll);
        if (barTop < this.getY()) {
            barTop = this.getY();
        }
        if (barTop > this.getY() + this.height - this.scrollHeight) {
            barTop = this.getY() + this.height - this.scrollHeight;
        }
        return barTop;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - this.scrollWidth - 2;
    }

    public int getRowWidth() {
        return this.width - this.scrollWidth - 4;
    }

    protected void renderListBackground(GuiGraphics gui) {
    }

    protected void renderSelection(GuiGraphics gui, int top, int width, int height, int outerColor, int innerColor) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        if (this.getMaxScroll() > 0) {
            int barX = this.getScrollbarPosition();
            int barY = this.getScrollBarTop();
            if (mouseX >= (double)barX && mouseX <= (double)(barX + this.scrollWidth) && mouseY >= (double)barY && mouseY <= (double)(barY + this.scrollHeight)) {
                this.isScrolling = true;
                this.scrollClickOffset = mouseY - (double)barY;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int maxScroll = this.getMaxScroll();
            int trackHeight = this.height;
            if (trackHeight > this.scrollHeight) {
                double d0 = mouseY - (double)this.getY() - this.scrollClickOffset;
                double newScroll = d0 * (double)maxScroll / (double)(trackHeight - this.scrollHeight);
                this.setScrollAmount(newScroll);
            }
            return true;
        }
        return false;
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
        @NotNull
        public Component getNarration() {
            return Component.empty();
        }
    }
}

