/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client.models;

import com.tyzsskills.client.SoundPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CustomTabButton
extends Button {
    private final ResourceLocation texture;
    private final int u;
    private final int v;
    private final int uHover;
    private final int vHover;
    private final int uActive;
    private final int vActive;
    private final int textureW;
    private final int textureH;
    private final Supplier<Boolean> isActiveCdt;

    public CustomTabButton(int x, int y, int width, int height, int u, int v, int uHover, int vHover, int uActive, int vActive, int textureW, int textureH, Supplier<Boolean> isActiveCdt, ResourceLocation texture, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.uHover = uHover;
        this.vHover = vHover;
        this.uActive = uActive;
        this.vActive = vActive;
        this.textureW = textureW;
        this.textureH = textureH;
        this.isActiveCdt = isActiveCdt;
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        boolean isActive = this.isActiveCdt.get();
        boolean isHover = this.isHovered();
        int currentU = this.u;
        int currentV = this.v;
        if (isActive) {
            currentU = this.uActive;
            currentV = this.vActive;
        } else if (isHover) {
            currentU = this.uHover;
            currentV = this.vHover;
        }
        gui.blit(this.texture, this.getX(), this.getY(), (float)currentU, (float)currentV, this.width, this.height, this.textureW, this.textureH);
    }

    public void setFocused(boolean focused) {
        super.setFocused(false);
    }

    public void playDownSound(SoundManager handler) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            SoundPlayer.PlayUIClick();
        }
    }
}

