/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client.models;

import com.tyzsskills.client.ClientCache;
import com.tyzsskills.client.SoundPlayer;
import com.tyzsskills.client.screen.MainGUI;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.Trait;
import com.tyzsskills.server.payloads.CActionSkillPayload;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.neoforged.neoforge.network.PacketDistributor;

public class SkillWidget {
    protected static final ResourceLocation DEFAULT_ICON = ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"textures/gui/skills/default.png");
    protected static final ResourceLocation REF_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"textures/gui/background.png");
    protected static final int TEXTURE_W = 325;
    protected static final int TEXTURE_H = 325;
    protected static final int U_BACKGROUND = 166;
    protected static final int V_BACKGROUND = 142;
    protected static final int U_BACKGROUND_FINAL = 230;
    protected static final int WIDTH = 64;
    protected static final int HEIGHT = 30;
    protected static final int BTN_W = 9;
    protected static final int BTN_H = 9;
    protected static final int U_BUY_BTN = 169;
    protected static final int V_BUY_BTN = 173;
    protected static final int U_BUY_BTN_HOVER = 178;
    protected static final int U_BOOK_BTN_HOVER = 226;
    protected static final int V_BOOK_BTN_HOVER = 173;
    protected static final int U_BOOK_ACTIVE = 237;
    protected static final int V_BOOK_ACTIVE = 174;
    protected static final int U_BOOK_NEUTRAL = 246;
    protected static final int U_REFUND_BTN = 200;
    protected static final int V_REFUND_BTN = 173;
    protected static final int U_REFUND_BTN_HOVER = 209;
    protected final Skill skill;
    protected final ResourceLocation icon;
    protected int x;
    protected int y;
    protected static final int COLOR_BG = -721420288;
    protected static final int COLOR_BORDER = -2708139;

    public SkillWidget(Skill skill) {
        this.skill = skill;
        ResourceLocation candidate = ResourceLocation.tryParse((String)skill.GetIcon());
        this.icon = candidate != null && Minecraft.getInstance().getResourceManager().getResource(candidate).isPresent() ? candidate : DEFAULT_ICON;
    }

    public void render(GuiGraphics gui, int x, int y, int mouseX, int mouseY, float partialTick) {
        this.x = x;
        this.y = y;
        Font font = Minecraft.getInstance().font;
        int currentU = 166;
        if (ClientCache.GetSkillLevel(this.skill.GetID().toLowerCase()) >= this.skill.GetMaximumLevel()) {
            currentU = 230;
        }
        gui.blit(REF_TEXTURE, x, y, (float)currentU, 142.0f, 64, 30, 325, 325);
        gui.blit(REF_TEXTURE, x + 49, y + 17, 246.0f, 174.0f, 9, 9, 325, 325);
        gui.blit(this.icon, x + 7, y + 7, 0.0f, 0.0f, 16, 16, 16, 16);
        MutableComponent count = Component.translatable((String)"gui.tyzs_skills.Lvl").append(": " + ClientCache.GetSkillLevel(this.skill.GetID()) + "/" + this.skill.GetMaximumLevel());
        float scale = 0.58f;
        int fixedWidth = (int)(30.0f / scale);
        int textHeight = font.wordWrapHeight((FormattedText)count, fixedWidth);
        int padding = 3;
        gui.pose().pushPose();
        gui.pose().translate((float)(x + 29), (float)(y + 8), 0.0f);
        gui.pose().scale(scale, scale, 1.0f);
        this.renderBackdrop(gui, -padding, -padding, fixedWidth + padding * 2, textHeight + padding * 2, -721420288);
        gui.drawWordWrap(font, (FormattedText)count, 0, 1, fixedWidth, 0xFFFFFF);
        gui.pose().popPose();
        boolean isHoveringBookBtn = this.isMouseOver(mouseX, mouseY, x + 49, y + 17, 9, 9);
        if (isHoveringBookBtn) {
            gui.blit(REF_TEXTURE, x + 48, y + 16, 226.0f, 173.0f, 11, 11, 325, 325);
        }
        if (ClientCache.GetBookmarkState(this.skill.GetID().toLowerCase())) {
            gui.blit(REF_TEXTURE, x + 49, y + 17, 237.0f, 174.0f, 9, 9, 325, 325);
        }
        if (this.CanBuy(this.skill)) {
            boolean isHoverBuyBtn = this.isMouseOver(mouseX, mouseY, x + 38, y + 17, 9, 9);
            int currentBuyU = 169;
            if (isHoverBuyBtn) {
                currentBuyU = 178;
            }
            gui.blit(REF_TEXTURE, x + 38, y + 17, (float)currentBuyU, 173.0f, 9, 9, 325, 325);
        }
        if (this.CanRefund(this.skill)) {
            boolean isHoverRefundBtn = this.isMouseOver(mouseX, mouseY, x + 27, y + 17, 9, 9);
            int currentRefundU = 200;
            if (isHoverRefundBtn) {
                currentRefundU = 209;
            }
            gui.blit(REF_TEXTURE, x + 27, y + 17, (float)currentRefundU, 173.0f, 9, 9, 325, 325);
        }
    }

    public List<Component> getTooltip(int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (this.CanRefund(this.skill) && this.isMouseOver(mouseX, mouseY, this.x + 27, this.y + 17, 9, 9)) {
            tooltip.add((Component)Component.translatable((String)"gui.tyzs_skills.refund"));
        }
        if (this.skill.IsPurchasable() && this.isMouseOver(mouseX, mouseY, this.x + 38, this.y + 17, 9, 9)) {
            int maxLevel = this.skill.GetMaximumLevel();
            int currentLevel = ClientCache.GetSkillLevel(this.skill.GetID().toLowerCase());
            if (currentLevel < maxLevel) {
                float currentValue = currentLevel <= 0 ? 0.0f : this.skill.GetValues().get(currentLevel - 1).floatValue();
                float nextValue = this.skill.GetValues().get(currentLevel).floatValue();
                String valueDiff = MainGUI.SmartFormat(nextValue - currentValue);
                MutableComponent text = Component.empty().append((Component)this.GetPriceString(this.skill));
                tooltip.add((Component)text);
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "+")).append((Component)Component.literal((String)(valueDiff + " " + String.valueOf(ChatFormatting.GREEN)))).append((Component)Component.translatable((String)this.skill.GetUnit())).withStyle(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.translatable((String)"gui.tyzs_skills.level_max").withStyle(ChatFormatting.GOLD));
            }
            return tooltip;
        }
        if (this.isMouseOver(mouseX, mouseY, this.x + 4, this.y + 4, 22, 22)) {
            tooltip.add((Component)Component.translatable((String)this.skill.GetDisplayName()).withStyle(ChatFormatting.DARK_PURPLE));
            String rawDesc = Component.translatable((String)this.skill.GetDescription()).getString();
            if (rawDesc.contains("{value}")) {
                int currentLvl = ClientCache.GetSkillLevel(this.skill.GetID().toLowerCase());
                List<Float> values = this.skill.GetValues();
                float val = 0.0f;
                if (values != null && !values.isEmpty()) {
                    if (currentLvl > 0) {
                        int index2 = Math.min(currentLvl - 1, values.size() - 1);
                        val = values.get(index2).floatValue();
                    }
                    String coloredValue = String.valueOf(ChatFormatting.GREEN) + MainGUI.SmartFormat(val) + String.valueOf(ChatFormatting.GRAY);
                    rawDesc = rawDesc.replace("{value}", coloredValue);
                } else {
                    rawDesc = rawDesc.replace("{value}", String.valueOf(ChatFormatting.GREEN) + "0" + String.valueOf(ChatFormatting.GRAY));
                }
            }
            Font font = Minecraft.getInstance().font;
            MutableComponent fullDesc = Component.literal((String)rawDesc).withStyle(ChatFormatting.GRAY);
            List splitLines = font.split((FormattedText)fullDesc, 152);
            for (FormattedCharSequence line : splitLines) {
                MutableComponent lineComponent = Component.empty();
                line.accept((index, style, codePoint) -> {
                    lineComponent.append((Component)Component.literal((String)String.valueOf((char)codePoint)).withStyle(style));
                    return true;
                });
                tooltip.add((Component)lineComponent);
            }
        }
        return tooltip;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOver(mouseX, mouseY, this.x, this.y, 64, 30);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver((int)mouseX, (int)mouseY, this.x + 38, this.y + 17, 9, 9)) {
            if (!this.CanBuy(this.skill)) {
                return false;
            }
            SoundPlayer.PlayUIClick();
            ClientCache.PredictBuy(this.skill);
            PacketDistributor.sendToServer((CustomPacketPayload)new CActionSkillPayload(this.skill.GetID().toLowerCase(), 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (this.isMouseOver((int)mouseX, (int)mouseY, this.x + 27, this.y + 17, 9, 9)) {
            if (!this.CanRefund(this.skill)) {
                return false;
            }
            SoundPlayer.PlayUIClick();
            ClientCache.PredictRefund(this.skill);
            PacketDistributor.sendToServer((CustomPacketPayload)new CActionSkillPayload(this.skill.GetID().toLowerCase(), 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (this.isMouseOver((int)mouseX, (int)mouseY, this.x + 49, this.y + 17, 9, 9)) {
            SoundPlayer.PlayUIClick();
            ClientCache.PredictBookmark(this.skill);
            PacketDistributor.sendToServer((CustomPacketPayload)new CActionSkillPayload(this.skill.GetID().toLowerCase(), 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (ClientCache.GetCategoryType() == Skill.CategoryType.BOOKMARKS) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof MainGUI) {
                    MainGUI gui = (MainGUI)screen;
                    gui.refreshList();
                }
                return true;
            }
        }
        return false;
    }

    protected boolean CanBuy(Skill skill) {
        LocalPlayer client = Minecraft.getInstance().player;
        if (client == null || skill == null) {
            return false;
        }
        if (!skill.IsPurchasable() || !skill.IsSkillActive()) {
            return false;
        }
        int currentLvl = ClientCache.GetSkillLevel(skill.GetID());
        if (currentLvl >= skill.GetMaximumLevel()) {
            return false;
        }
        List<Integer> prices = skill.GetPrices();
        if (currentLvl >= prices.size()) {
            return false;
        }
        int price = prices.get(currentLvl);
        return price <= ClientCache.GetSP();
    }

    protected boolean CanRefund(Skill skill) {
        List<Integer> prices;
        LocalPlayer client = Minecraft.getInstance().player;
        if (client == null || skill == null) {
            return false;
        }
        if (!ClientCache.GetConfigBool("refund_system", false) || !skill.IsSkillActive()) {
            return false;
        }
        int currentLvl = ClientCache.GetSkillLevel(skill.GetID());
        if (currentLvl > skill.GetMaximumLevel() || currentLvl < 1) {
            return false;
        }
        if (this.skill.GetType() == Skill.SkillType.GENERIC) {
            String powerAttrId = AttributeRegistry.TRAIT_POWER.getId().toString();
            if (this.skill.GetModifier().equals(powerAttrId)) {
                float currentValue;
                AttributeInstance att = client.getAttribute(AttributeRegistry.TRAIT_POWER);
                if (att == null) {
                    return false;
                }
                int max = (int)att.getValue();
                int current = ClientCache.GetPower();
                int index = Math.min(currentLvl - 1, skill.GetValues().size() - 1);
                float powerLoss = currentValue = skill.GetValues().get(index).floatValue();
                if (currentLvl > 1) {
                    int prevIndex = Math.min(currentLvl - 2, skill.GetValues().size() - 1);
                    float prevValue = skill.GetValues().get(prevIndex).floatValue();
                    powerLoss = currentValue - prevValue;
                }
                if (current > max - (int)powerLoss) {
                    return false;
                }
            }
        }
        return currentLvl <= (prices = skill.GetPrices()).size();
    }

    protected MutableComponent GetPriceString(Skill skill) {
        LocalPlayer client = Minecraft.getInstance().player;
        if (skill == null || !skill.IsPurchasable() || client == null) {
            return Component.translatable((String)"gui.tyzs_skills.error_value");
        }
        int currentLvl = ClientCache.GetSkillLevel(skill.GetID());
        if (currentLvl > skill.GetMaximumLevel()) {
            return Component.translatable((String)"gui.tyzs_skills.error_value");
        }
        if (currentLvl == skill.GetMaximumLevel()) {
            return Component.translatable((String)"gui.tyzs_skills.level_max").withStyle(ChatFormatting.GOLD);
        }
        List<Integer> prices = skill.GetPrices();
        if (currentLvl >= prices.size()) {
            return Component.translatable((String)"gui.tyzs_skills.error_value");
        }
        return this.CanBuy(skill) ? Component.translatable((String)"gui.tyzs_skills.cost").withStyle(ChatFormatting.GRAY).append(": ").append((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + String.valueOf(prices.get(currentLvl))))).append(" ").append((Component)Component.translatable((String)"gui.tyzs_skills.SP").withStyle(ChatFormatting.BLUE)) : Component.translatable((String)"gui.tyzs_skills.cost").append(": ").append((Component)Component.literal((String)String.valueOf(prices.get(currentLvl)))).append(" ").append((Component)Component.translatable((String)"gui.tyzs_skills.SP")).withStyle(ChatFormatting.RED);
    }

    protected boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    protected void renderBackdrop(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x, y + 1, x + width, y + height - 1, color);
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
        if (this.skill instanceof Trait) {
            return;
        }
        if (ClientCache.GetSkillLevel(this.skill.GetID().toLowerCase()) < this.skill.GetMaximumLevel()) {
            return;
        }
        gui.fill(x + 1, y, x + width - 1, y + 1, -2708139);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, -2708139);
        gui.fill(x, y + 1, x + 1, y + height - 1, -2708139);
        gui.fill(x + width - 1, y + 1, x + width, y + height - 1, -2708139);
    }
}

