/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client.models;

import com.tyzsskills.client.ClientCache;
import com.tyzsskills.client.models.SkillWidget;
import com.tyzsskills.client.screen.MainGUI;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.Trait;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public class TraitWidget
extends SkillWidget {
    private static final int U_INACTIVE = 166;
    private static final int V_INACTIVE = 142;
    private static final int U_ACTIVE = 82;
    private static final int V_ACTIVE = 251;
    private Trait trait;

    public TraitWidget(Skill skill) {
        super(skill);
    }

    @Override
    public void render(GuiGraphics gui, int x, int y, int mouseX, int mouseY, float partialTick) {
        this.x = x;
        this.y = y;
        this.trait = (Trait)this.skill;
        Font font = Minecraft.getInstance().font;
        boolean isOwned = ClientCache.GetSkillLevel(this.trait.GetID().toLowerCase()) > 0;
        int currentU = isOwned ? 82 : 166;
        int currentV = isOwned ? 251 : 142;
        gui.blit(REF_TEXTURE, x, y, (float)currentU, (float)currentV, 64, 30, 325, 325);
        gui.blit(this.icon, x + 7, y + 7, 0.0f, 0.0f, 16, 16, 16, 16);
        MutableComponent state = isOwned ? Component.translatable((String)"gui.tyzs_skills.active") : Component.translatable((String)"gui.tyzs_skills.inactive");
        int color = isOwned ? -14846683 : -7395802;
        float scale = 0.58f;
        int fixedWidth = (int)(30.0f / scale);
        int textHeight = font.wordWrapHeight((FormattedText)state, fixedWidth);
        int padding = 3;
        gui.pose().pushPose();
        gui.pose().translate((float)(x + 29), (float)(y + 8), 0.0f);
        gui.pose().scale(scale, scale, 1.0f);
        this.renderBackdrop(gui, -padding, -padding, fixedWidth + padding * 2, textHeight + padding * 2, color);
        gui.drawWordWrap(font, (FormattedText)state, 0, 1, fixedWidth, 0xFFFFFF);
        gui.pose().popPose();
        if (this.CanBuy(this.skill)) {
            boolean isHoverBuyBtn = this.isMouseOver(mouseX, mouseY, x + 38, y + 17, 9, 9);
            int currentBuyU = 169;
            if (isHoverBuyBtn) {
                currentBuyU = 178;
            }
            gui.blit(REF_TEXTURE, x + 38, y + 17, (float)currentBuyU, 173.0f, 9, 9, 325, 325);
        }
        if (this.CanRefund(this.skill)) {
            boolean isHoverRefundBtn = this.isMouseOver(mouseX, mouseY, x + 27, y + 17, 9, 9);
            int currentRefundU = 200;
            if (isHoverRefundBtn) {
                currentRefundU = 209;
            }
            gui.blit(REF_TEXTURE, x + 27, y + 17, (float)currentRefundU, 173.0f, 9, 9, 325, 325);
        }
    }

    @Override
    public List<Component> getTooltip(int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (this.CanRefund(this.skill) && this.isMouseOver(mouseX, mouseY, this.x + 27, this.y + 17, 9, 9)) {
            tooltip.add((Component)Component.translatable((String)"gui.tyzs_skills.refund"));
            return tooltip;
        }
        if (this.skill.IsPurchasable() && this.skill.IsSkillActive() && this.isMouseOver(mouseX, mouseY, this.x + 38, this.y + 17, 9, 9)) {
            AttributeInstance attr;
            int currentLvl = ClientCache.GetSkillLevel(this.skill.GetID());
            if (currentLvl >= this.skill.GetMaximumLevel()) {
                tooltip.add((Component)Component.translatable((String)"gui.tyzs_skills.level_max").withStyle(ChatFormatting.GOLD));
                return tooltip;
            }
            List<Integer> prices = this.skill.GetPrices();
            if (currentLvl >= prices.size()) {
                return tooltip;
            }
            int price = prices.get(currentLvl);
            if (ClientCache.GetSP() < price) {
                tooltip.add((Component)Component.empty().append((Component)this.GetPriceString(this.skill)));
                return tooltip;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && (attr = player.getAttribute(AttributeRegistry.TRAIT_POWER)) != null) {
                int maxPower = (int)attr.getValue();
                int futurePower = ClientCache.GetPower() + this.trait.getPowerWeight();
                if (futurePower > maxPower) {
                    tooltip.add((Component)Component.translatable((String)"gui.tyzs_skills.power_needed").withStyle(ChatFormatting.RED));
                    return tooltip;
                }
            }
            tooltip.add((Component)Component.empty().append((Component)this.GetPriceString(this.skill)));
            MutableComponent powerTrad = Component.translatable((String)"gui.tyzs_skills.power");
            String powerLow = powerTrad.getString().toLowerCase();
            tooltip.add((Component)Component.literal((String)"+").append((Component)Component.literal((String)String.valueOf(this.trait.getPowerWeight()))).append((Component)Component.literal((String)" ")).append((Component)Component.literal((String)powerLow)).withStyle(ChatFormatting.RED));
            return tooltip;
        }
        if (this.isMouseOver(mouseX, mouseY, this.x + 4, this.y + 4, 22, 22)) {
            tooltip.add((Component)Component.translatable((String)this.skill.GetDisplayName()).withStyle(ChatFormatting.DARK_PURPLE));
            String rawDesc = Component.translatable((String)this.skill.GetDescription()).getString();
            if (rawDesc.contains("{value}")) {
                int currentLvl = ClientCache.GetSkillLevel(this.skill.GetID().toLowerCase());
                List<Float> values = this.skill.GetValues();
                float val = 0.0f;
                if (values != null && !values.isEmpty()) {
                    if (currentLvl > 0) {
                        int index2 = Math.min(currentLvl - 1, values.size() - 1);
                        val = values.get(index2).floatValue();
                    }
                    String coloredValue = String.valueOf(ChatFormatting.GREEN) + MainGUI.SmartFormat(val) + String.valueOf(ChatFormatting.GRAY);
                    rawDesc = rawDesc.replace("{value}", coloredValue);
                } else {
                    rawDesc = rawDesc.replace("{value}", String.valueOf(ChatFormatting.GREEN) + "0" + String.valueOf(ChatFormatting.GRAY));
                }
            }
            Font font = Minecraft.getInstance().font;
            MutableComponent fullDesc = Component.literal((String)rawDesc).withStyle(ChatFormatting.GRAY);
            List splitLines = font.split((FormattedText)fullDesc, 152);
            for (FormattedCharSequence line : splitLines) {
                MutableComponent lineComponent = Component.empty();
                line.accept((index, style, codePoint) -> {
                    lineComponent.append((Component)Component.literal((String)String.valueOf((char)codePoint)).withStyle(style));
                    return true;
                });
                tooltip.add((Component)lineComponent);
            }
            MutableComponent powerTrad = Component.translatable((String)"gui.tyzs_skills.power");
            String powerLow = powerTrad.getString().toLowerCase();
            MutableComponent powerComponent = Component.literal((String)("(" + this.trait.getPowerWeight() + " ")).append((Component)Component.literal((String)powerLow)).append((Component)Component.literal((String)")")).withStyle(ChatFormatting.BLUE);
            tooltip.add((Component)powerComponent);
        }
        return tooltip;
    }

    @Override
    protected boolean CanBuy(Skill skill) {
        LocalPlayer client = Minecraft.getInstance().player;
        if (client == null || skill == null) {
            return false;
        }
        if (!skill.IsPurchasable() || !skill.IsSkillActive()) {
            return false;
        }
        int currentLvl = ClientCache.GetSkillLevel(skill.GetID());
        if (currentLvl >= skill.GetMaximumLevel()) {
            return false;
        }
        List<Integer> prices = skill.GetPrices();
        if (currentLvl >= prices.size()) {
            return false;
        }
        int price = prices.get(currentLvl);
        AttributeInstance attr = client.getAttribute(AttributeRegistry.TRAIT_POWER);
        if (attr == null) {
            return false;
        }
        int freeSpace = (int)attr.getValue() - ClientCache.GetPower();
        if (this.trait.getPowerWeight() > freeSpace) {
            return false;
        }
        return price <= ClientCache.GetSP();
    }
}

