/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client.screen;

import com.tyzsskills.Config;
import com.tyzsskills.client.ClientCache;
import com.tyzsskills.client.SoundPlayer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class LevelTriggerOverlay
implements LayeredDraw.Layer {
    private static int currentLevel = 0;
    private static int accumulatedSp = 0;
    private static long lastUpdateTime = 0L;
    private static long appearanceTime = 0L;
    private static final long fadeIn = 300L;
    private static final long fadeOut = 500L;
    private static final float SCALE = 0.5f;
    private static final int MARGIN = 4;

    public static void ShowLevelUp(int level, int spReward) {
        long duration;
        boolean isActive;
        if (!((Boolean)Config.SHOW_LEVEL_OVERLAY.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (mc.player.isCreative() && !((Boolean)Config.SHOW_OVERLAYS_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean bl = isActive = now - lastUpdateTime < (duration = (long)((Double)Config.LEVEL_DURATION.get() * 1000.0));
        if (!isActive) {
            currentLevel = level;
            accumulatedSp = spReward;
            appearanceTime = now;
        } else {
            currentLevel = Math.max(currentLevel, level);
            accumulatedSp += spReward;
        }
        lastUpdateTime = now;
        SoundPlayer.PlayLevelUpSound();
    }

    public static void Clear() {
        accumulatedSp = 0;
        currentLevel = 0;
        lastUpdateTime = 0L;
        appearanceTime = 0L;
    }

    public void render(GuiGraphics gui, DeltaTracker deltaTracker) {
        long duration;
        long now = System.currentTimeMillis();
        long timeSinceUpdate = now - lastUpdateTime;
        if (timeSinceUpdate > (duration = (long)((Double)Config.LEVEL_DURATION.get() * 1000.0)) || currentLevel <= 0) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        long timeSinceAppearance = now - appearanceTime;
        float alpha = 1.0f;
        float yOffset = 0.0f;
        if (timeSinceAppearance < 300L) {
            float progress = (float)timeSinceAppearance / 300.0f;
            alpha = progress = (float)Math.sin((double)progress * Math.PI / 2.0);
            yOffset = (1.0f - progress) * 20.0f;
        } else if (timeSinceUpdate > duration - 500L) {
            alpha = (float)(duration - timeSinceUpdate) / 500.0f;
        }
        alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        if (alpha <= 0.05f) {
            return;
        }
        int cfgBg = ClientCache.ParseColor((String)Config.LEVEL_BG_COLOR.get(), -1442840576);
        int cfgBorder = ClientCache.ParseColor((String)Config.LEVEL_BD_COLOR.get(), -2708139);
        int cfgText = ClientCache.ParseColor((String)Config.LEVEL_TEXT_COLOR.get(), -1);
        int spBaseColor = ClientCache.ParseColor((String)Config.LEVEL_SCD_TEXT_COLOR.get(), -2708139);
        int spBaseAlpha = spBaseColor >> 24 & 0xFF;
        int spFinalAlpha = (int)((float)spBaseAlpha * alpha);
        int spFinal = spFinalAlpha << 24 | spBaseColor & 0xFFFFFF;
        String spTextRaw = Component.translatable((String)"gui.tyzs_skills.SP").getString().toUpperCase();
        MutableComponent text = Component.translatable((String)"overlay.tyzs_skills.level").append((Component)Component.literal((String)(" " + String.valueOf(currentLevel)))).append((Component)Component.literal((String)(" [+" + accumulatedSp + " " + spTextRaw + "]")).withColor(spFinal));
        int textWidth = font.width((FormattedText)text);
        int padding = 6;
        int height = 12 + padding * 2;
        int width = textWidth + padding * 2;
        gui.pose().pushPose();
        gui.pose().scale(0.5f, 0.5f, 1.0f);
        int scaledScreenHeight = (int)((float)screenHeight / 0.5f);
        int baseX = 8;
        int baseY = scaledScreenHeight - height - 8;
        baseX += (int)((float)((Integer)Config.LEVEL_OFFSET_X.get()).intValue() / 0.5f);
        int boxHeightWithMargin = height + 4;
        int y = (baseY -= (int)((float)((Integer)Config.LEVEL_OFFSET_Y.get()).intValue() / 0.5f)) - boxHeightWithMargin;
        int bgFinal = (int)((float)(cfgBg >> 24 & 0xFF) * alpha) << 24 | cfgBg & 0xFFFFFF;
        int borderFinal = (int)((float)(cfgBorder >> 24 & 0xFF) * alpha) << 24 | cfgBorder & 0xFFFFFF;
        int textFinal = (int)((float)(cfgText >> 24 & 0xFF) * alpha) << 24 | cfgText & 0xFFFFFF;
        this.renderTooltipStyleRect(gui, baseX, y += (int)yOffset, width, height, bgFinal);
        this.renderTooltipStyleBorder(gui, baseX, y, width, height, borderFinal);
        gui.drawString(font, (Component)text, baseX + padding, y + padding + 2, textFinal, true);
        gui.pose().popPose();
    }

    private void renderTooltipStyleRect(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x, y + 1, x + width, y + height - 1, color);
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
    }

    private void renderTooltipStyleBorder(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
        gui.fill(x, y + 1, x + 1, y + height - 1, color);
        gui.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }
}

