/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client.screen;

import com.tyzsskills.client.ClientCache;
import com.tyzsskills.client.models.CustomScrollView;
import com.tyzsskills.client.models.CustomTabButton;
import com.tyzsskills.client.models.SkillEntry;
import com.tyzsskills.client.models.SkillWidget;
import com.tyzsskills.client.models.TraitWidget;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.model.Skill;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MainGUI
extends Screen {
    private static final ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"textures/gui/background.png");
    private static final ResourceLocation mainFont = ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"main_font");
    private final int imageWidth = 301;
    private final int imageHeight = 139;
    private int leftPos;
    private int topPos;
    private CustomTabButton skillBtn;
    private CustomTabButton traitBtn;
    private CustomTabButton allBtn;
    private CustomTabButton abilitiesBtn;
    private CustomTabButton fightBtn;
    private CustomTabButton miscBtn;
    private CustomTabButton bookmarksBtn;
    private CustomScrollView scrollView;

    public MainGUI() {
        super((Component)Component.translatable((String)"gui.tyzs_skills.title"));
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.addButtons();
        this.addScrollView();
        this.refreshList();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(background, this.leftPos, this.topPos, 0.0f, 0.0f, 301, 139, 325, 325);
        this.renderStrings(guiGraphics, mouseX, mouseY);
        this.renderXpBar(guiGraphics);
        if (ClientCache.GetContainerType() == Skill.ContainerType.TRAITS) {
            this.renderPowerBar(guiGraphics);
        }
        this.renderEntity(guiGraphics, 30, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderIcons(guiGraphics);
        this.updateButtonsVisibility();
        this.renderTooltips(guiGraphics, mouseX, mouseY);
    }

    private void renderStrings(GuiGraphics gui, int mouseX, int mouseY) {
        float scale = 0.6f;
        int yOffset = 1;
        int color1 = this.isHovering(mouseX, mouseY, this.leftPos, this.topPos + 81, 36, 12) ? 14069077 : -1;
        MutableComponent lvlStat = Component.translatable((String)"gui.tyzs_skills.Lvl");
        gui.pose().pushPose();
        gui.pose().translate((float)(this.leftPos + 7), (float)(this.topPos + 84 + yOffset), 0.0f);
        gui.pose().scale(scale, scale, 1.0f);
        gui.drawString(this.font, (Component)lvlStat, 0, 0, color1, false);
        gui.pose().popPose();
        MutableComponent lvlValue = Component.literal((String)String.valueOf(ClientCache.GetLvl()));
        int text1W = this.font.width((FormattedText)lvlValue);
        int rightLimit1 = this.leftPos + 31;
        gui.pose().pushPose();
        gui.pose().translate((float)rightLimit1, (float)(this.topPos + 84 + yOffset), 0.0f);
        gui.pose().scale(scale, scale, 1.0f);
        gui.drawString(this.font, (Component)lvlValue, -text1W, 0, color1, false);
        gui.pose().popPose();
        int color2 = this.isHovering(mouseX, mouseY, this.leftPos + 37, this.topPos + 81, 36, 12) ? 14069077 : -1;
        MutableComponent spStat = Component.translatable((String)"gui.tyzs_skills.SP");
        gui.pose().pushPose();
        gui.pose().translate((float)(this.leftPos + 46), (float)(this.topPos + 84 + yOffset), 0.0f);
        gui.pose().scale(scale, scale, 1.0f);
        gui.drawString(this.font, (Component)spStat, 0, 0, color2, false);
        gui.pose().popPose();
        MutableComponent spValue = Component.literal((String)String.valueOf(ClientCache.GetSP()));
        int text2W = this.font.width((FormattedText)spValue);
        int rightLimit2 = this.leftPos + 69;
        gui.pose().pushPose();
        gui.pose().translate((float)rightLimit2, (float)(this.topPos + 84 + yOffset), 0.0f);
        gui.pose().scale(scale, scale, 1.0f);
        gui.drawString(this.font, (Component)spValue, -text2W, 0, color2, false);
        gui.pose().popPose();
        if (ClientCache.GetContainerType() == Skill.ContainerType.TRAITS) {
            MutableComponent text = Component.translatable((String)"gui.tyzs_skills.traits");
            int textW = this.font.width((FormattedText)text);
            Objects.requireNonNull(this.font);
            int textH = 9;
            int padding = 3;
            this.renderBackdrop(gui, this.leftPos + 90 - padding, this.topPos + 12 - padding, textW + padding * 2, textH + padding * 2, -721420288);
            gui.drawString(this.font, (Component)text, this.leftPos + 90, this.topPos + 13, -1, false);
        } else {
            if (ClientCache.GetCategoryType() == Skill.CategoryType.BOOKMARKS) {
                return;
            }
            String localizationKey = "gui.tyzs_skills.Tab." + ClientCache.GetCategoryType().toString().toLowerCase();
            MutableComponent enumDisplayName = Component.translatable((String)localizationKey);
            int text3W = this.font.width((FormattedText)enumDisplayName);
            int rightLimit3 = this.leftPos + 293;
            int textW = this.font.width((FormattedText)enumDisplayName);
            Objects.requireNonNull(this.font);
            int textH = 9;
            int padding = 3;
            this.renderBackdrop(gui, rightLimit3 - text3W - padding, this.topPos + 12 - padding, textW + padding * 2, textH + padding * 2, -721420288);
            gui.drawString(this.font, (Component)enumDisplayName, rightLimit3 - text3W, this.topPos + 13, -1, false);
        }
    }

    private void renderXpBar(GuiGraphics gui) {
        float xpStat = ClientCache.GetXP();
        float xpGoal = ClientCache.GetXPGOAL();
        if (xpGoal <= 0.0f) {
            return;
        }
        float ratio = Math.min(1.0f, xpStat / xpGoal);
        int widthToDraw = (int)(ratio * 70.0f);
        if (widthToDraw > 0) {
            gui.blit(background, this.leftPos + 2, this.topPos + 98, 82.0f, 142.0f, widthToDraw, 5, 325, 325);
        }
    }

    private void renderPowerBar(GuiGraphics gui) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        AttributeInstance attr = player.getAttribute(AttributeRegistry.TRAIT_POWER);
        if (attr == null) {
            return;
        }
        double maxPower = attr.getValue();
        if (maxPower <= 0.0) {
            maxPower = 1.0;
        }
        int currentPower = ClientCache.GetPower();
        double ratio = Math.min(1.0, (double)currentPower / maxPower);
        gui.blit(background, this.leftPos + 173, this.topPos + 17, 82.0f, 285.0f, 124, 7, 325, 325);
        boolean isFull = ratio >= 1.0;
        int currentV = isFull ? 297 : 292;
        int widthToDraw = (int)(ratio * 122.0);
        if (widthToDraw > 0) {
            gui.blit(background, this.leftPos + 174, this.topPos + 18, 83.0f, (float)currentV, widthToDraw, 5, 325, 325);
        }
    }

    private void renderEntity(GuiGraphics gui, int scale, int mouseX, int mouseY) {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        int renderX = this.leftPos + 29;
        int renderY = this.topPos + 72;
        float mouseXOffset = (float)renderX - (float)mouseX;
        float mouseYOffset = (float)(renderY - 50) - (float)mouseY;
        float f = (float)Math.atan((double)mouseXOffset / 40.0);
        float f1 = (float)Math.atan((double)mouseYOffset / 40.0);
        Quaternionf quatF = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quatF1 = new Quaternionf().rotateX(f1 * 20.0f * (float)Math.PI / 180.0f);
        quatF.mul((Quaternionfc)quatF1);
        float f2 = player.yBodyRot;
        float f3 = player.getYRot();
        float f4 = player.getXRot();
        float f5 = player.yHeadRotO;
        float f6 = player.yHeadRot;
        player.yBodyRot = 180.0f + f * 20.0f;
        player.setYRot(180.0f + f * 40.0f);
        player.setXRot(-f1 * 20.0f);
        player.yHeadRot = player.getYRot();
        player.yHeadRotO = player.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)gui, (float)renderX, (float)renderY, (float)scale, (Vector3f)new Vector3f(), (Quaternionf)quatF, null, (LivingEntity)player);
        player.yBodyRot = f2;
        player.setYRot(f3);
        player.setXRot(f4);
        player.yHeadRot = f5;
        player.yHeadRotO = f6;
    }

    private void renderTooltips(GuiGraphics gui, int mouseX, int mouseY) {
        List<Component> lines;
        SkillWidget hoveredWidget;
        MutableComponent finalText;
        if (this.isHovering(mouseX, mouseY, this.leftPos, this.topPos + 96, 75, 8)) {
            String xpTooltip = MainGUI.SmartFormat(ClientCache.GetXP()) + "/" + MainGUI.SmartFormat(ClientCache.GetXPGOAL());
            finalText = Component.literal((String)xpTooltip).append((Component)Component.literal((String)(" [+" + MainGUI.SmartFormat(ClientCache.GetReward()) + " ")).withStyle(ChatFormatting.GREEN)).append((Component)Component.translatable((String)"gui.tyzs_skills.SP").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.GREEN));
            gui.renderTooltip(this.font, (Component)finalText, mouseX, mouseY);
        }
        if (ClientCache.GetContainerType() == Skill.ContainerType.TRAITS && this.isHovering(mouseX, mouseY, this.leftPos + 173, this.topPos + 17, 123, 6)) {
            String powerTooltip = MainGUI.SmartFormat(ClientCache.GetPower()) + "/" + MainGUI.SmartFormat((float)Minecraft.getInstance().player.getAttribute(AttributeRegistry.TRAIT_POWER).getValue());
            finalText = Component.translatable((String)"gui.tyzs_skills.power").append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)powerTooltip));
            gui.renderTooltip(this.font, (Component)finalText, mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, this.leftPos + 55, this.topPos + 6, 15, 15)) {
            gui.renderTooltip(this.font, (Component)Component.translatable((String)"gui.tyzs_skills.Skills"), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, this.leftPos + 55, this.topPos + 24, 15, 15) && ClientCache.GetConfigBool("trait_system", true)) {
            int traitLvl = ClientCache.GetConfigInt("trait_unlock", 20);
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"gui.tyzs_skills.traits"));
            if (ClientCache.GetLvl() < traitLvl) {
                tooltip.add(Component.translatable((String)"overlay.tyzs_skills.level").append(" " + traitLvl).withStyle(ChatFormatting.RED));
            }
            gui.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
        if (this.scrollView != null && this.scrollView.visible && this.scrollView.isMouseOver(mouseX, mouseY) && (hoveredWidget = this.scrollView.getHoveredWidget(mouseX, mouseY)) != null && !(lines = hoveredWidget.getTooltip(mouseX, mouseY)).isEmpty()) {
            gui.renderComponentTooltip(this.font, lines, mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, this.leftPos + 43, this.topPos + 65, 8, 8)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"gui.tyzs_skills.stats.all_time_xp").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)MainGUI.SmartFormat(ClientCache.GetAllTimeXp())).withStyle(ChatFormatting.GRAY)));
            tooltip.add(Component.translatable((String)"gui.tyzs_skills.stats.session_xp").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)MainGUI.SmartFormat(ClientCache.GetSessionXp())).withStyle(ChatFormatting.GRAY)));
            tooltip.add(Component.translatable((String)"gui.tyzs_skills.stats.sp_earned").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)String.valueOf(ClientCache.GetSpEarned())).withStyle(ChatFormatting.GRAY)));
            tooltip.add(Component.translatable((String)"gui.tyzs_skills.stats.sp_spent").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)String.valueOf(ClientCache.GetSpSpent())).withStyle(ChatFormatting.GRAY)));
            tooltip.add(Component.translatable((String)"gui.tyzs_skills.stats.skill_unlocked").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)(ClientCache.GetUnlockedSkills() + "/" + ClientCache.GetSkillCount())).withStyle(ChatFormatting.GRAY)));
            gui.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
        if (ClientCache.GetContainerType() != Skill.ContainerType.SKILLS) {
            return;
        }
        if (this.isHovering(mouseX, mouseY, this.leftPos + 92, this.topPos + 7, 29, 20)) {
            gui.renderTooltip(this.font, (Component)Component.translatable((String)"gui.tyzs_skills.Tab.all"), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, this.leftPos + 123, this.topPos + 7, 29, 20)) {
            gui.renderTooltip(this.font, (Component)Component.translatable((String)"gui.tyzs_skills.Tab.abilities"), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, this.leftPos + 154, this.topPos + 7, 29, 20)) {
            gui.renderTooltip(this.font, (Component)Component.translatable((String)"gui.tyzs_skills.Tab.fight"), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, this.leftPos + 185, this.topPos + 7, 29, 20)) {
            gui.renderTooltip(this.font, (Component)Component.translatable((String)"gui.tyzs_skills.Tab.misc"), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, this.leftPos + 216, this.topPos + 7, 29, 20)) {
            gui.renderTooltip(this.font, (Component)Component.translatable((String)"gui.tyzs_skills.Tab.bookmarks"), mouseX, mouseY);
        }
    }

    private void addButtons() {
        this.skillBtn = new CustomTabButton(this.leftPos + 55, this.topPos + 6, 14, 14, 83, 154, 97, 154, 111, 154, 325, 325, () -> ClientCache.GetContainerType() == Skill.ContainerType.SKILLS, background, b -> {
            ClientCache.SetContainerType(Skill.ContainerType.SKILLS);
            this.refreshList();
        });
        this.addRenderableWidget((GuiEventListener)this.skillBtn);
        this.traitBtn = new CustomTabButton(this.leftPos + 55, this.topPos + 21, 14, 14, 83, 168, 97, 168, 111, 168, 325, 325, () -> ClientCache.GetContainerType() == Skill.ContainerType.TRAITS, background, b -> {
            ClientCache.SetContainerType(Skill.ContainerType.TRAITS);
            this.refreshList();
        });
        this.addRenderableWidget((GuiEventListener)this.traitBtn);
        this.allBtn = new CustomTabButton(this.leftPos + 92, this.topPos + 7, 29, 20, 82, 187, 82, 227, 82, 207, 325, 325, () -> ClientCache.GetCategoryType() == Skill.CategoryType.ALL, background, b -> {
            ClientCache.SetCategoryType(Skill.CategoryType.ALL);
            this.refreshList();
        });
        this.addRenderableWidget((GuiEventListener)this.allBtn);
        this.abilitiesBtn = new CustomTabButton(this.leftPos + 123, this.topPos + 7, 29, 20, 140, 187, 140, 227, 140, 207, 325, 325, () -> ClientCache.GetCategoryType() == Skill.CategoryType.ABILITIES, background, b -> {
            ClientCache.SetCategoryType(Skill.CategoryType.ABILITIES);
            this.refreshList();
        });
        this.addRenderableWidget((GuiEventListener)this.abilitiesBtn);
        this.fightBtn = new CustomTabButton(this.leftPos + 154, this.topPos + 7, 29, 20, 111, 187, 111, 227, 111, 207, 325, 325, () -> ClientCache.GetCategoryType() == Skill.CategoryType.FIGHT, background, b -> {
            ClientCache.SetCategoryType(Skill.CategoryType.FIGHT);
            this.refreshList();
        });
        this.addRenderableWidget((GuiEventListener)this.fightBtn);
        this.miscBtn = new CustomTabButton(this.leftPos + 185, this.topPos + 7, 29, 20, 169, 187, 169, 227, 169, 207, 325, 325, () -> ClientCache.GetCategoryType() == Skill.CategoryType.MISC, background, b -> {
            ClientCache.SetCategoryType(Skill.CategoryType.MISC);
            this.refreshList();
        });
        this.addRenderableWidget((GuiEventListener)this.miscBtn);
        this.bookmarksBtn = new CustomTabButton(this.leftPos + 216, this.topPos + 7, 29, 20, 198, 187, 198, 227, 198, 207, 325, 325, () -> ClientCache.GetCategoryType() == Skill.CategoryType.BOOKMARKS, background, b -> {
            ClientCache.SetCategoryType(Skill.CategoryType.BOOKMARKS);
            this.refreshList();
        });
        this.addRenderableWidget((GuiEventListener)this.bookmarksBtn);
    }

    private void renderIcons(GuiGraphics gui) {
        this.renderIcon(gui, 0.65f, 233, 191, 15, 16, this.leftPos + 43, this.topPos + 65, 8);
    }

    private void updateButtonsVisibility() {
        boolean isSkillMode;
        boolean bl = isSkillMode = ClientCache.GetContainerType() == Skill.ContainerType.SKILLS;
        if (this.allBtn != null) {
            this.allBtn.visible = isSkillMode;
        }
        if (this.abilitiesBtn != null) {
            this.abilitiesBtn.visible = isSkillMode;
        }
        if (this.fightBtn != null) {
            this.fightBtn.visible = isSkillMode;
        }
        if (this.miscBtn != null) {
            this.miscBtn.visible = isSkillMode;
        }
        if (this.bookmarksBtn != null) {
            this.bookmarksBtn.visible = isSkillMode;
        }
        if (this.traitBtn != null) {
            this.traitBtn.visible = ClientCache.GetConfigBool("trait_system", true);
        }
    }

    private void addScrollView() {
        this.scrollView = new CustomScrollView(this.minecraft, this.leftPos + 83, this.topPos + 27, 213, 106, 32, background, 325, 325, 142, 149, 149, 149, 7, 16);
        this.addRenderableWidget((GuiEventListener)this.scrollView);
    }

    public void refreshList() {
        if (this.scrollView == null) {
            return;
        }
        Skill.ContainerType containerType = ClientCache.GetContainerType();
        this.scrollView.clearEntries();
        int maxPerLine = 3;
        SkillEntry currentRow = null;
        int countInRow = 0;
        if (containerType == Skill.ContainerType.TRAITS) {
            for (Skill skill : ClientCache.GetAllSkills()) {
                if (skill.GetCategory() != Skill.CategoryType.TRAITS) continue;
                if (currentRow == null || countInRow >= maxPerLine) {
                    currentRow = new SkillEntry();
                    this.scrollView.AddEntry(currentRow);
                    countInRow = 0;
                }
                currentRow.addWidget(new TraitWidget(skill));
                ++countInRow;
            }
            this.scrollView.setScrollAmount(0.0);
        } else {
            Skill.CategoryType categoryToLoad = ClientCache.GetCategoryType();
            for (Skill skill : ClientCache.GetAllSkills()) {
                if (skill.GetCategory() == Skill.CategoryType.TRAITS || skill.GetCategory() != categoryToLoad && categoryToLoad != Skill.CategoryType.ALL && categoryToLoad != Skill.CategoryType.BOOKMARKS || categoryToLoad == Skill.CategoryType.BOOKMARKS && !ClientCache.GetBookmarkState(skill.GetID())) continue;
                if (currentRow == null || countInRow >= maxPerLine) {
                    currentRow = new SkillEntry();
                    this.scrollView.AddEntry(currentRow);
                    countInRow = 0;
                }
                currentRow.addWidget(new SkillWidget(skill));
                ++countInRow;
            }
            this.scrollView.setScrollAmount(0.0);
        }
    }

    public static String SmartFormat(float value) {
        if (value == (float)((long)value)) {
            return String.format("%d", (long)value);
        }
        return String.format(Locale.US, "%.1f", Float.valueOf(value));
    }

    private boolean isHovering(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private void renderIcon(GuiGraphics gui, float scale, int u, int v, int w, int h, int btnX, int btnY, int btnS) {
        float scaledSize = (float)w * scale;
        float offset = ((float)btnS - scaledSize) / 2.0f;
        float targetVisualX = (float)btnX + offset;
        float targetVisualY = (float)btnY + offset;
        int drawX = (int)(targetVisualX / scale);
        int drawY = (int)(targetVisualY / scale);
        gui.pose().pushPose();
        gui.pose().scale(scale, scale, 1.0f);
        gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        gui.blit(background, drawX, drawY, (float)u, (float)v, w, h, 325, 325);
        gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        gui.pose().popPose();
    }

    private void renderBackdrop(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x, y + 1, x + width, y + height - 1, color);
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
        gui.fill(x + 1, y, x + width - 1, y + 1, -1);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, -1);
        gui.fill(x, y + 1, x + 1, y + height - 1, -1);
        gui.fill(x + width - 1, y + 1, x + width, y + height - 1, -1);
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }
}

