/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tyzsskills.Config;
import com.tyzsskills.client.ClientCache;
import com.tyzsskills.server.model.Skill;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SkillTriggerOverlay
implements LayeredDraw.Layer {
    private static final List<Notification> activeNotifications = new ArrayList<Notification>();
    private static final long fadeIn = 200L;
    private static final long fadeOut = 500L;
    private static final int spacing = 32;
    private static final float scale = 0.65f;
    private static final ResourceLocation DEFAULT_ICON = ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"textures/gui/skills/default.png");

    public static void ShowSkillIcon(String id) {
        if (!((Boolean)Config.SHOW_SKILL_OVERLAY.get()).booleanValue()) {
            return;
        }
        Skill skill = ClientCache.GetSkill(id.toLowerCase());
        if (skill != null) {
            ResourceLocation icon = ResourceLocation.tryParse((String)skill.GetIcon());
            if (icon == null || Minecraft.getInstance().getResourceManager().getResource(icon).isEmpty()) {
                icon = DEFAULT_ICON;
            }
            long now = System.currentTimeMillis();
            for (int i = 0; i < activeNotifications.size(); ++i) {
                Notification current = activeNotifications.get(i);
                if (!current.icon.equals((Object)icon)) continue;
                activeNotifications.set(i, new Notification(icon, current.creationTime, now));
                return;
            }
            activeNotifications.add(new Notification(icon, now, now));
        }
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (activeNotifications.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (mc.player.isCreative() && !((Boolean)Config.SHOW_OVERLAYS_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        int height = mc.getWindow().getGuiScaledHeight();
        long now = System.currentTimeMillis();
        long duration = (long)((Double)Config.SKILL_DURATION.get() * 1000.0);
        activeNotifications.removeIf(n -> now - n.lastUpdate > duration);
        if (activeNotifications.isEmpty()) {
            return;
        }
        int index = 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        for (Notification notif : activeNotifications) {
            this.renderSingleNotification(guiGraphics, notif, index, height, now);
            ++index;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderSingleNotification(GuiGraphics guiGraphics, Notification notif, int index, int screenHeight, long now) {
        long age = now - notif.creationTime;
        long idleTime = now - notif.lastUpdate;
        long duration = (long)((Double)Config.SKILL_DURATION.get() * 1000.0);
        float alpha = 1.0f;
        if (age < 200L) {
            alpha = (float)age / 200.0f;
        } else if (idleTime > duration - 500L) {
            alpha = (float)(duration - idleTime) / 500.0f;
        } else {
            float timeInPhase = age - 200L;
            float speed = 0.01f;
            alpha = 0.8f + 0.2f * Mth.sin((float)(timeInPhase * speed));
        }
        alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        if (alpha <= 0.05f) {
            return;
        }
        int cfgBg = ClientCache.ParseColor((String)Config.SKILL_BG_COLOR.get(), -1442840576);
        int cfgBorder = ClientCache.ParseColor((String)Config.SKILL_BD_COLOR.get(), -2708139);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.65f, 0.65f, 1.0f);
        int iconSize = 16;
        int padding = 5;
        int boxSize = iconSize + padding * 2;
        int scaledScreenHeight = (int)((float)screenHeight / 0.65f);
        int startY = (int)((float)scaledScreenHeight * 0.25f);
        int offsetX = (int)((float)((Integer)Config.SKILL_OFFSET_X.get()).intValue() / 0.65f);
        int offsetY = (int)((float)((Integer)Config.SKILL_OFFSET_Y.get()).intValue() / 0.65f);
        int drawX = padding + 2 + offsetX;
        int drawY = startY + index * 32 - offsetY;
        int boxY = drawY - padding;
        int boxX = drawX - padding;
        int bgFinal = (int)((float)(cfgBg >> 24 & 0xFF) * alpha) << 24 | cfgBg & 0xFFFFFF;
        int borderFinal = (int)((float)(cfgBorder >> 24 & 0xFF) * alpha) << 24 | cfgBorder & 0xFFFFFF;
        this.renderTooltipStyleRect(guiGraphics, boxX, boxY, boxSize, boxSize, bgFinal);
        this.renderTooltipStyleBorder(guiGraphics, boxX, boxY, boxSize, boxSize, borderFinal);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.blit(notif.icon(), drawX, drawY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        guiGraphics.pose().popPose();
    }

    public static void Clear() {
        activeNotifications.clear();
    }

    private void renderTooltipStyleRect(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x, y + 1, x + width, y + height - 1, color);
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
    }

    private void renderTooltipStyleBorder(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
        gui.fill(x, y + 1, x + 1, y + height - 1, color);
        gui.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    private record Notification(ResourceLocation icon, long creationTime, long lastUpdate) {
    }
}

